<?php

namespace App\Console\Commands;

use Illuminate\Console\Command;
use App\Services\Accounting\FeeInvoiceService;
use Illuminate\Support\Facades\Log;

class DailyCollectionToIncome extends Command
{

    protected $signature = 'app:daily-collection-to-income';
    protected $description = 'Convert daily collection to income records';
    protected FeeInvoiceService $feeInvoiceService;

    public function __construct(FeeInvoiceService $feeInvoiceService)
    {
        parent::__construct();
        $this->feeInvoiceService = $feeInvoiceService;
    }

    public function handle()
    {
        $this->info('Daily collection to income started');

        try{
            $this->feeInvoiceService->storeDailyCollectionToIncome();
            $this->info('Daily collection to income completed');
        }catch(\Exception $e){
            Log::error('Error processing daily collection: ' . $e->getMessage());
            $this->error('An error occurred while processing the daily collection.');
        }
    }
}
