<?php

namespace App\Console\Commands;

use App\Models\Scopes\BranchFilterScope;
use App\Services\Inventory\SalesService;
use App\Models\Accounting\Invoice;
use App\Models\Accounting\Income;
use Illuminate\Console\Command;
use App\Models\Academic\Branch;
use App\Constants\Settings;
use App\Constants\Status;
use Carbon\Carbon;
use Illuminate\Support\Facades\DB;

class DailySalesToIncome extends Command
{

    /**
     * The name and signature of the console command.
     *
     * @var string
     */
    protected $signature = 'app:daily-sales-to-income';

    /**
     * The console command description.
     *
     * @var string
     */
    protected $description = 'Convert daily sales to income records';


    protected SalesService $salesService;

    public function __construct(SalesService $salesService)
    {
        parent::__construct(); // Call the parent constructor
        $this->salesService = $salesService; // Inject service
    }

    /**
     * Execute the console command.
     */
    public function handle()
    {
        $this->info('Daily inventory to income started');
        
        $today = Carbon::now()->toDateString();
        $branches = Branch::all();

        foreach ($branches as $branch) {
                
            $branchSales = $this->salesService->branchWiseTodaySale($branch->id);
            
            foreach ($branchSales as $sale) {

                //check existing income record
                $existingIncome = DB::table('incomes')
                    ->where('branch_id', $branch->id)
                    ->where('accounting_head_id', $sale->accounting_head_id)
                    ->where('income_date', $today)
                    ->first();

                if (!$existingIncome) {
                    if ($sale->total_amount > 0) {
                        Income::create([
                            'branch_id' => $sale->branch_id,
                            'invoice_no' => Invoice::withoutGlobalScope(BranchFilterScope::class)->max('invoice_no') + 1,
                            'accounting_head_id' => $sale->accounting_head_id,
                            'income_date' => $today,
                            'amount' => $sale->total_amount,
                            'description' => 'Daily inventory product sales',
                            'created_at' => $today,
                            'updated_at' => $today,
                        ]);
                    }
                }
            }
            
        }

        $this->info('Daily inventory to income completed');
    }
}
