<?php

namespace App\Console;

use Illuminate\Console\Scheduling\Schedule;
use Illuminate\Foundation\Console\Kernel as ConsoleKernel;

class Kernel extends ConsoleKernel
{
    /**
     * Define the application's command schedule.
     */
    protected function schedule(Schedule $schedule): void
    {
        $schedule->command('app:daily-collection-to-income')->dailyAt('00:00');
        $schedule->command('app:daily-sales-to-income')->dailyAt('00:00');
        $schedule->command('app:daily-sales-to-income')->dailyAt('00:00');
        $schedule->command('app:send-fee-collection-alert-sms')->dailyAt('10:00');
        $schedule->command('app:student-birthday-wishes')->dailyAt('10:00');
        $schedule->command('app:student-fee-due-sms')->dailyAt('10:00');

        $schedule->command('queue:work --stop-when-empty')->everyMinute();

        
    }

    /**
     * Register the commands for the application.
     */
    protected function commands(): void
    {
        $this->load(__DIR__.'/Commands');

        require base_path('routes/console.php');
    }
} 