<?php

namespace App\Constants;

class Accounting
{
    public const INCOME = 'income';
    public const EXPENSE = 'expense';
    public const CURRENT = 'Current Account';
    public const SAVINGS  = 'Savings Account';
    public const EDUCATION = 'Education Savings Plan';

    public const CASH = 'Cash';
    public const BKASH = 'Bkash';
    public const ROCKET = 'Rocket';
    public const NOGOD = 'Nogod';
    public const BANK = 'Bank';
    public const IBBL = 'IBBL';
    public const TUITION = 'Tuition';
    public const EXAM = 'Exam';
    public const TRANSPORT = 'Transport';
    public const HOSTEL = 'Hostel';
    public const ADMISSION = 'Admission';
    public const OTHER = 'Other';

    public const PAYMENT_METHOD = [
        self::CASH => self::CASH,
        self::BKASH => self::BKASH,
        self::ROCKET => self::ROCKET,
        self::NOGOD => self::NOGOD,
        self::BANK => self::BANK,
        self::IBBL => self::IBBL,
    ];

    public const AC_HEAD_TYPE = [
        self::INCOME,
        self::EXPENSE,
    ];

    public const BANK_ACCOUNT_TYPE = [
        self::CURRENT,
        self::SAVINGS,
        self::EDUCATION,
    ];

    public const FEE_TYPES = [
        self::TUITION => self::TUITION,
        self::EXAM => self::EXAM,
        self::TRANSPORT => self::TRANSPORT,
        self::HOSTEL => self::HOSTEL,
        self::ADMISSION => self::ADMISSION,
        self::OTHER => self::OTHER,
    ];

    private function __construct(){}
}

