<?php
namespace App\Constants;
class Status
{
    public const PENDING = 'pending';
    public const DRAFT = 'draft';
    public const APPROVED = 'approved';
    public const REJECTED = 'rejected';
    public const PUBLISHED = 'published';
    public const UNPUBLISHED = 'unpublished';
    public const ACTIVE = 'active';
    public const INACTIVE = 'inactive';
    public const HOLD = 'hold';
    public const DELIVERED = 'delivered';
    public const FAILED = 'failed';
    public const GRADUATED = 'graduated';
    public const ASSIGNED = 'assigned';
    public const PAID = 'Paid';
    public const UNPAID = 'Unpaid';
    public const DUE = 'Due';
    public const MARRIED = 'Married';
    public const SINGLE = 'Single';
    public const DIVORCED = 'Divorced';
    public const PRESENT = 'Present';
    public const ABSENT = 'Absent';
    public const LATE = 'Late';
    
    public const USER_STATUS_LIST = [
        self::PENDING,
        self::APPROVED,
        self::REJECTED,
        self::ACTIVE,
        self::INACTIVE,
    ];
    public const PAYMENT_STATUS_LIST = [
        self::PAID => self::PAID,
        self::UNPAID => self::UNPAID,
        self::DUE => self::DUE,
    ];
    public const STUDENT_HOSTEL_STATUS = [
        self::ASSIGNED => self::ASSIGNED,
        self::HOLD => self::HOLD,
    ];
    public const MARITAL_STATUS = [
        self::MARRIED => self::MARRIED,
        self::SINGLE => self::SINGLE,
        self::DIVORCED => self::DIVORCED,
    ];
    public const NOTICE_STATUS = [
        self::PUBLISHED => self::PUBLISHED,
        self::UNPUBLISHED => self::UNPUBLISHED,
    ];
    public const ATTENDANCE_STATUS = [
        self::PRESENT => self::PRESENT,
        self::ABSENT => self::ABSENT,
        self::LATE => self::LATE,
    ];
    public static function STUDENT_STATUS() {
        return [
            self::ACTIVE => ucfirst(self::ACTIVE),
            self::INACTIVE => ucfirst(self::INACTIVE),
            self::GRADUATED => ucfirst(self::GRADUATED),
        ];
    }
    private function __construct() {}
}