<?php

namespace App\Exports;

use Illuminate\Contracts\View\View;
use Maatwebsite\Excel\Concerns\FromView;

class ExportStudentHostel implements FromView
{
    protected $data;
    protected $metadata;
    protected $selectedColumns;

    public function __construct($data, $metadata, $selectedColumns)
    {
        $this->data = $data;
        $this->metadata = $metadata;
        $this->selectedColumns = $selectedColumns;
    }

    public function view(): View
    {
        return view('report.hostel.hostel-excel', [
            'hostels' => $this->data,
            'hostel_name' => $this->metadata['hostel_name'] ?? 'N/A',
            'institute_name' => $this->metadata['institute_name'] ?? 'N/A',
            'report_name' => $this->metadata['report_name'] ?? 'N/A',
            'columns' => $this->selectedColumns,
        ]);
    }
}
