<?php

namespace App\Exports;

use Maatwebsite\Excel\Concerns\FromView;
use Maatwebsite\Excel\Concerns\WithHeadings;
use Maatwebsite\Excel\Concerns\WithTitle;
use Illuminate\Contracts\View\View;

class GenericExport implements FromView, WithHeadings, WithTitle
{
    protected $data;
    protected $columns;
    protected $title;
    protected $subtitle;

    public function __construct($data, $columns, $title, $subtitle = null)
    {
        $this->data = $data;
        $this->columns = $columns;
        $this->title = $title;
        $this->subtitle = $subtitle;
    }

    public function view(): View
    {
        return view('exports.excel-template', [
            'data' => $this->data,
            'columns' => $this->columns,
            'title' => $this->title,
            'subtitle' => $this->subtitle
        ]);
    }

    public function headings(): array
    {
        return $this->columns;
    }

    public function title(): string
    {
        return $this->title;
    }

    public function subtitle(): string
    {
        return $this->subtitle;
    }
}
