<?php

namespace App\Exports;

// use App\Models\Attendance\StudentAttendance;
// use Maatwebsite\Excel\Concerns\FromCollection;
use Illuminate\Contracts\View\View;
use Maatwebsite\Excel\Concerns\FromView;
use Maatwebsite\Excel\Concerns\WithDrawings;
use Maatwebsite\Excel\Concerns\WithCustomStartCell;
use PhpOffice\PhpSpreadsheet\Worksheet\Drawing;

class StudentAttendanceExport implements FromView
{

    protected $data;
    protected $selectedColumns;
    public function __construct($data,$selectedColumns)
    {
        $this->data = $data;
        $this->class_name = $data['class_name'];
        $this->shift_name = $data['shift_name'];
        $this->form_date = $data['form_date'];
        $this->to_date = $data['to_date'];
        $this->institute_name = $data['institute_name'];
        $this->report_title = $data['report_title'];
        $this->selectedColumns = $selectedColumns;
    }

    public function view(): View
    {
        return view('report.attendance.date-to-date-excel', [
            'attendances' => $this->data,
            'class_name' => $this->class_name,
            'shift_name' => $this->shift_name,
            'form_date' => $this->form_date,
            'to_date' => $this->to_date,
            'institute_name' => $this->institute_name,
            'report_title' => $this->report_title,
            'columns' => $this->selectedColumns,
        ]);
    }


}
