<?php

namespace App\Exports;

use Illuminate\Contracts\View\View;
use Maatwebsite\Excel\Concerns\FromView;


class TranspoerExport implements FromView
{
    protected $data;
    protected $selectedColumns;
    public function __construct($data,$selectedColumns)
    {
        $this->data = $data;
        $this->route_name = $data['route_name'];
        $this->vehicle_number = $data['vehicle_number'];
        $this->driver_name = $data['driver_name'];
        $this->driver_contact = $data['driver_contact'];
        $this->institute_name = $data['institute_name'];
        $this->report_name = $data['report_name'];
        $this->selectedColumns = $selectedColumns;
    }

    public function view(): View
    {
        return view('report.transport.route-wise-transport-excel', [
            'transports' => $this->data,
            'route_name' => $this->route_name,
            'vehicle_number' => $this->vehicle_number,
            'driver_name' => $this->driver_name,
            'driver_contact' => $this->driver_contact,
            'institute_name' => $this->institute_name,
            'report_name' => $this->report_name,
            'columns' => $this->selectedColumns,
        ]);
    }
}
