<?php

namespace App\Exports;

use Illuminate\Contracts\View\View;
use Maatwebsite\Excel\Concerns\FromView;

class TypeWiseAttendance implements FromView
{
    protected $data;
    protected $selectedColumns;
    public function __construct($data,$selectedColumns)
    {
        $this->data = $data;
        $this->class_name = $data['class_name'];
        $this->shift_name = $data['shift_name'];
        $this->attendance_type = $data['attendance_type'];
        $this->form_date = $data['form_date'];
        $this->to_date = $data['to_date'];
        $this->institute_name = $data['institute_name'];
        $this->report_title = $data['report_title'];
        $this->selectedColumns = $selectedColumns;
    }

    public function view(): View
    {
        return view('report.attendance.type-wise-excel', [
            'attendances' => $this->data,
            'class_name' => $this->class_name,
            'shift_name' => $this->shift_name,
            'attendance_type' => $this->attendance_type,
            'form_date' => $this->form_date,
            'to_date' => $this->to_date,
            'institute_name' => $this->institute_name,
            'report_title' => $this->report_title,
            'columns' => $this->selectedColumns,
        ]);
    }
}
