<?php

declare(strict_types=1);

namespace App\Filters\Components;

use Closure;

class AcademicYear implements ComponentInterface
{
    public function handle(array $contents, Closure $next): mixed
    {
        $builder = $contents['builder'];
        $params = $contents['params'];

        // Use 'academic_year_id' by default if no prefix is provided
        $column = $params['academic_year_prefix'] ?? 'academic_year_id';

        if (isset($params['academic_year_id']) && !empty($params['academic_year_id'])) {
            $builder->where($column, $params['academic_year_id']);
        }

        return $next($contents);
    }
}
