<?php

declare(strict_types=1);

namespace App\Filters\Components;

use Closure;

class DateRange implements ComponentInterface
{
    public function handle(array $content, Closure $next): mixed
    {
        // Check if both 'from_date' and 'to_date' dates are provided in the request params
        if (isset($content['params']['from_date']) && isset($content['params']['to_date'])) {
            $from = $content['params']['from_date'];
            $to = $content['params']['to_date'];

            // Apply the date range filter to the builder query
            $content['builder']->whereBetween('created_at', [$from, $to]);
        } elseif (isset($content['params']['from_date'])) {
            // If only 'from_date' is provided, apply the 'from_date' filter
            $from = $content['params']['from_date'];
            $content['builder']->where('created_at', '>=', $from);
        } elseif (isset($content['params']['to_date'])) {
            // If only 'to_date' is provided, apply the 'to_date' filter
            $to = $content['params']['to_date'];
            $content['builder']->where('created_at', '<=', $to);
        }

        return $next($content);
    }
}

