<?php

declare(strict_types=1);

namespace App\Filters\Components;

use Closure;

class Department implements ComponentInterface
{
    public function handle(array $content, Closure $next): mixed
    {
        if (isset($content['params']['department_id'])) {
            $value = $content['params']['department_id'];

            $content['builder']->where('department', '=', $value);
        }

        return $next($content);
    }
}
