<?php

declare(strict_types=1);

namespace App\Filters\Components;

use Closure;

class EmployeeCode implements ComponentInterface
{
    public function handle(array $content, Closure $next): mixed
    {
        if (isset($content['params']['employee_code'])) {
            $value = $content['params']['employee_code'];

            $content['builder']->where('employee_code', '=', $value);
        }

        return $next($content);
    }
}
