<?php

declare(strict_types=1);

namespace App\Filters\Components;

use Closure;

class Month implements ComponentInterface
{
    public function handle(array $contents, Closure $next): mixed
    {
        $builder = $contents['builder'];
        $params = $contents['params'];

        // Use 'month' by default if no prefix is provided
        $column = $params['month_prefix'] ?? 'month';

        if (isset($params['month']) && !empty($params['month'])) {
            $builder->where($column, $params['month']);
        }

        return $next($contents);
    }
}
