<?php

declare(strict_types=1);

namespace App\Filters\Components;

use Closure;

class Section implements ComponentInterface
{
    public function handle(array $content, Closure $next): mixed
    {
        if (isset($content['params']['section'])) {
            $value = $content['params']['section'];

            $content['builder']->where('section_id', '=', $value);
        }

        return $next($content);
    }
}
