<?php

declare(strict_types=1);

namespace App\Filters\Components;

use App\Models\Student\StudentInfo;
use Closure;

class StudentId implements ComponentInterface
{
    public function handle(array $content, Closure $next): mixed
    {
        if (isset($content['params']['student_id_no'])) {
            $value = $content['params']['student_id_no'];
            $student = StudentInfo::where('student_id_no', '=', $value)->first();
            $content['builder']->where('id', '=', $student->id);
        }

        return $next($content);
    }
}
