<?php

//====================Author Md. Masum ====================//
use Carbon\Carbon;
use App\Models\Setting;
use App\Constants\Status;
use App\Constants\Settings;
use App\Models\Result\Exam;
use App\Models\Result\Grade;
use App\Models\Academic\Branch;
use App\Models\Syllabus\Lesson;
use App\Models\Academic\Subject;
use App\Services\SettingService;
use Illuminate\Support\HtmlString;
use App\Models\Student\StudentInfo;
use App\Models\Syllabus\LessonTopic;
use Illuminate\Support\Facades\Gate;
use App\Models\Academic\AcademicYear;
use Illuminate\Support\Facades\Cache;
use Illuminate\Support\Facades\Route;
use Illuminate\Database\Eloquent\Collection;
use Illuminate\Pagination\LengthAwarePaginator;
use App\Models\Admission\OnlineAdmissionSetting;


if (!function_exists('onlineAdmissionSetting')) {
    function onlineAdmissionSetting() {
        return OnlineAdmissionSetting::orderBy('id', 'desc')->first() ?? null;
    }
}



if (!function_exists('admission_class_roll')) {
    function admission_class_roll($class_id, $department_id, $shift_id = null, $section_id = null) {
        // 1. Fetch the maximum current roll number for this specific group
        $maxRoll = StudentInfo::where('branch_id', auth()->user()->branch_id) // Usually branch_id, not user id
            ->where('student_class_id', $class_id)
            ->where('department', $department_id)
            ->where('shift_id', $shift_id)
            ->where('section_id', $section_id)
            ->max('class_roll');

        // 2. Return max + 1, or start at 1 if no students exist
        return $maxRoll ? $maxRoll + 1 : 1;
    }
}



if (!function_exists('subject_name')) {
    function subject_name($id = '')
    {
        if (empty($id)) {
            return null;
        }
        try {
            return Subject::find($id)->subject_name ?? '';
        } catch (\Exception $e) {
            return null; // Or handle error as needed
        }
    }
}

if (!function_exists('time_format')) {
    function time_format($time = '', $format = 'H:i:s')
    {
        if (empty($time)) {
            return null;
        }
        try {
            return Carbon::createFromFormat($format, $time)->format('h:i A');
        } catch (\Exception $e) {
            return null; // Or handle error as needed
        }
    }
}

function view_date_format($date,$format='d-m-Y'){
    return Carbon::parse($date)->format($format);
}
function store_date_format($date){
    return Carbon::parse($date)->format('Y-m-d');
}

function lesson_topics($student_class_id,$subject_id,$lesson_id){
    return LessonTopic::where([['student_class_id',$student_class_id],['subject_id',$subject_id],['lesson_id',$lesson_id]])->get();
}

function group_lesson_topics($student_class_id,$subject_id,$lesson_id){
    return LessonTopic::where([['student_class_id',$student_class_id],['subject_id',$subject_id],['lesson_id',$lesson_id]])->select('id','name')->get();
}

function group_lessons($exam_id,$student_class_id,$subject_id){
    return Lesson::where([['exam_id',$exam_id],['student_class_id',$student_class_id],['subject_id',$subject_id]])->select('id','name')->get();
}


function get_setting_store($key, $branch_id=0)
{
    $branch_id = auth()->user()->branch_id ?? $branch_id;
    return  Setting::where('key', $key)->where('branch_id', $branch_id)->select('key','value','branch_id')->first();
}
function get_setting($key, $branch_id=0)
{
    return app(SettingService::class)->getSetting($key);
}
function get_setting_value($key, $branch_id=0)
{
    $branch_id = auth()->user()->branch_id ?? $branch_id;
    return Setting::where('key', $key)->where('branch_id', $branch_id)->select('key','value','branch_id')->first()->value ?? '';
} 


function get_branch_info()
{
    return Branch::where('id', auth()->user()->branch_id)->first() ?? '';
}

if (!function_exists('unicode_slug')) {
    function unicode_slug($string)
    {
        return preg_replace('/\s+/u', '-', trim($string));
    }
}

if (!function_exists('date_convertion')) {
    function date_convertion($date, $format)
    {
        return date($format, strtotime($date));
    }
}

function time_in_am_pm($time)
{
    return date('h:i A', strtotime($time));
}

function convertDateFormat($dateString, $format = 'd-m-Y H:i:s')
{
    return Carbon::parse($dateString)->format($format);
}

if (!function_exists('get_month_name')) {
    function get_month_name($month_no)
    {
        return date('F', mktime(0, 0, 0, $month_no, 1));
    }
}

if (!function_exists('days_in_month')) {
    function days_in_month($month_no, $year)
    {
        return date('t', mktime(0, 0, 0, $month_no, 1, $year));
    }
}

if (!function_exists('getMonthShortName')) {
    function getMonthShortName($monthNumber)
    {
        $months = [
            1 => 'Jan',
            2 => 'Feb',
            3 => 'Mar',
            4 => 'Apr',
            5 => 'May',
            6 => 'Jun',
            7 => 'Jul',
            8 => 'Aug',
            9 => 'Sep',
            10 => 'Oct',
            11 => 'Nov',
            12 => 'Dec',
        ];
        return $months[$monthNumber];
    }
}

if (! function_exists('getDefaultAcademicYearID')) {
    function getDefaultAcademicYearID()
    {
        return Cache::remember('default_academic_year', 60 * 60, function () {
            return AcademicYear::where('is_default_year', 'yes')->first()?->id;
        });
    }
}
if (! function_exists('getDefaultAcademicYearID2')) {
    function getDefaultAcademicYearID2()
    {
        return AcademicYear::where('is_default_year', 'yes')->first()?->id;
    }
}

if (! function_exists('getDefaultAcademicYearValue')) {
    function getDefaultAcademicYearValue()
    {
        return Cache::remember('default_academic_year_value', 60 * 60, function () {
            $academicYear = AcademicYear::where('is_default_year', 'yes')->first();            
            return $academicYear ? $academicYear->year : null;
        });
    }
}

if (! function_exists('getDefaultAcademicYearValue2')) {
    function getDefaultAcademicYearValue2()
    {
        $academicYear = AcademicYear::where('is_default_year', 'yes')->first();            
        return $academicYear ? $academicYear->year : null;
    }
}

//get current active exam (is possible remane the column name)
function getCurrentActiveExamId(){
    return Exam::where('is_published', true)->first()?->id;
}

if (!function_exists('urlSegment')) {
    function urlSegment($index = null)
    {
        if ($index != "") {
            return request()->segments()[$index];
        } else {
            return request()->segments();
        }
    }
}

function lastDateOfMonth($month, $year=null)
{
    $year = $year ?: date('Y');
    $lastDay = Carbon::createFromDate($year, $month, 1)->endOfMonth();
    return $lastDay->toDateString();
}

function arrayPaginator($array, $request)
{
    $page = request()->input('page', 1);
    $perPage = 10;
    $offset = ($page * $perPage) - $perPage;

    return new LengthAwarePaginator(
        array_slice($array, $offset, $perPage, true),
        count($array),
        $perPage,
        $page,
        [
            'path' => $request->url(),
            'query' => $request->query()
        ]
    );
}

if (!function_exists('generateDropdown')) {
    function generateDropdown($items, $attributes = '', $selectedValue = null, $selectOption = '')
    {
        $options = $selectOption == '' ? "" : "<option value=''> $selectOption </option>";

        if (!empty($items)) {
            foreach ($items as $key => $value) {
                $isSelected = $selectedValue !== null && $selectedValue == $key;
                $options .= "<option value='{$key}' " . ($isSelected ? 'selected' : '') . ">{$value}</option>";
            }
        }

        $selectHtml = "<select {$attributes}>{$options}</select>";

        return new HtmlString($selectHtml);
    }
}

if (!function_exists('multiSelectDropdown')) {
    function multiSelectDropdown($items, $attributes = '', $selectedArrayValue = [], $placeholder = '')
    {
        $options = '';

        if (!empty($items)) {
            foreach ($items as $key => $value) {
                $isSelected = $selectedArrayValue !== [] && in_array($key, $selectedArrayValue);
                $options .= "<option value='{$key}' " . ($isSelected ? 'selected' : '') . ">{$value}</option>";
            }
        }

        $selectHtml = "<select {$attributes} multiple data-placeholder='$placeholder'>{$options}</select>";

        return new HtmlString($selectHtml);
    }
}

if (!function_exists('getStatus')) {
    function getStatus($status): string
    {
        switch ($status) {
            case 0:
                return '<span class="badge badge-warning">Inactive</span>';
            case 1:
                return '<span class="badge badge-success">Active</span>';
            default:
                return '';
        }
    }
}

function getStatusBadge($status)
{
    $badges = [
        Status::PENDING => 'warning',
        Status::DRAFT => 'secondary',
        Status::APPROVED => 'success',
        Status::REJECTED => 'danger',
        Status::PUBLISHED => 'info',
        Status::ACTIVE => 'success',
        Status::INACTIVE => 'danger',
        Status::HOLD => 'warning',
        Status::DELIVERED => 'success',
        Status::FAILED => 'danger',
        Status::ASSIGNED => 'primary',
        Status::PAID => 'success',
        Status::UNPAID => 'danger',
        Status::DUE => 'danger',
        Status::MARRIED => 'success',
        Status::SINGLE => 'info',
        Status::DIVORCED => 'danger',
    ];

    $badgeClass = $badges[$status] ?? 'secondary';

    return '<span class="badge badge-' . $badgeClass . '">' . ucfirst($status) . '</span>';
}

function getStudentStatusBadge($status)
{
    $badges = [
        Status::PENDING => 'warning',
        Status::DRAFT => 'secondary',
        Status::APPROVED => 'success',
        Status::REJECTED => 'danger',
        Status::PUBLISHED => 'info',
        Status::ACTIVE => 'success',
        Status::INACTIVE => 'danger',
        Status::HOLD => 'warning',
        Status::DELIVERED => 'success',
        Status::FAILED => 'danger',
        Status::ASSIGNED => 'primary',
        Status::PAID => 'success',
        Status::DUE => 'danger',
        Status::MARRIED => 'success',
        Status::SINGLE => 'info',
        Status::DIVORCED => 'danger',
    ];

    $badgeClass = $badges[$status] ?? 'secondary';

    return '<span class="badge bg-' . $badgeClass . '">' . ucfirst($status) . '</span>';
}

if (!function_exists('activeMenu')) {
    function activeMenu($routeName = '')
    {
        $route = Route::currentRouteName();
        if ($route == $routeName) {
            return 'active';
        } else {
            return '';
        }
    }
}

if (!function_exists('menuItem')) {
    function menuItem($route, $permission, $label)
    {
        if (Gate::allows($permission)) {
            $active = activeMenu($route);
            $url = route($route);
            return "<a class='collapse-item {$active}' href='{$url}'>{$label}</a>";
        }
        return '';
    }
}


if (!function_exists('capitalizeWords')) {
    function capitalizeWords($str)
    {
        $str = str_replace('_', ' ', $str);
        $str = str_replace('-', ' ', $str);
        $str = strtolower($str);
        $str = ucwords($str);
        return $str;
    }
}

//BD number validation
function isValidBangladeshiNumber($number)
{
    return preg_match('/^(?:\+?88)?01[3-9]\d{8}$/', $number);
}


if (!function_exists('paginationStartNumber')) {
    function paginationStartNumber($paginator)
    {
        return ($paginator->currentPage() - 1) * $paginator->perPage() + 1;
    }
}

function calculateFeeAmount($feeType, $selectedFeeTypes, $transport_fee, $hostel_fee)
{
    $amount = 0;
    if (array_key_exists($feeType->id, $selectedFeeTypes)) {
        $amount = $selectedFeeTypes[$feeType->id];
    }
    if ($feeType->code == "TRANSPORT" && $transport_fee) {
        $amount = $transport_fee->monthly_cost;
    }
    if ($feeType->code == "HOSTEL" && $hostel_fee) {
        $amount = $hostel_fee->cost_per_bed;
    }
    return $amount;
}

function calculateStudentDiscount($amount, $discount)
{
    $single_discount = 0;
    if (!empty($discount)) {
        if ($discount->discount_type == 'percentage' && $discount->amount > 0) {
            $single_discount = ($amount * $discount->amount) / 100;
        } elseif ($discount->discount_type == 'fixedamount' && $discount->amount > 0) {
            $single_discount = $discount->amount;
        }
    }
    return $single_discount;
}

function lateFineCalculation()
{
    $last_pay_day = get_setting_value(Settings::LATE_FINE_START_DAY);
    $today = date('d');
    $fine_amount = 0;
    if ($last_pay_day < $today) {
        $fine_amount = get_setting_value(Settings::LATE_FINE_AMOUNT);
    }

    return $fine_amount ?? 0;
}


function getStudentNameWithID($studentIdNo)
{
    $student = StudentInfo::where('student_id_no', $studentIdNo)->first();
    if (isset($student->name)) {
        return "{$student->name} ({$studentIdNo})";
    }
    return "";
}


function getFutureMonths($months)
{
    // Get the current month
    $currentMonth = date('n');

    // Filter the months array
    return array_filter($months, function ($month, $key) use ($currentMonth) {
        return $key >= $currentMonth; // Include current and future months
    }, ARRAY_FILTER_USE_BOTH);
}


function getPastMonths($months)
{
    // Get the current month
    $currentMonth = date('n');

    // Filter the months array
    return array_filter($months, function ($month, $key) use ($currentMonth) {
        return $key <= $currentMonth; // Include current and past months
    }, ARRAY_FILTER_USE_BOTH);
}

//all months array from date range
function getMonthsFromDateRange($fromDate, $toDate)
{
    $start = Carbon::parse($fromDate)->startOfMonth();
    $end = Carbon::parse($toDate)->endOfMonth();
    
    $months = [];

    while ($start->lte($end)) {
        $months[] = $start->month; // Add the month number
        $start->addMonth(); // Move to the next month
    }

    return $months;
}

function getMonthsBasedOnCurrent(int $previousMonthsCount = 3, int $nextMonthsCount = 2): array {
    $currentDate = new DateTime();
    $currentMonth = (int)$currentDate->format('n');
    $currentYear = (int)$currentDate->format('Y');
    $months = [];

    // Add previous months (including the current month)
    for ($i = 0; $i <= $previousMonthsCount; $i++) {
        $targetDate = clone $currentDate;
        $targetDate->modify("-$i months");
        
        // Only include if it's in the current year
        if ($targetDate->format('Y') == $currentYear) {
            $months[] = (int)$targetDate->format('n');
        }
    }

    // Add next months
    for ($i = 1; $i <= $nextMonthsCount; $i++) {
        $targetDate = clone $currentDate;
        $targetDate->modify("+$i months");
        
        // Only include if it's in the current year
        if ($targetDate->format('Y') == $currentYear) {
            $months[] = (int)$targetDate->format('n');
        }
    }

    // Sort months in descending order for consistency
    rsort($months);

    return array_values(array_unique($months));
}

function getEmployeeNameWithCode($employeeCode, $employees)
{
    if ($employeeCode) {
        // Handle paginator (Illuminate\Pagination\LengthAwarePaginator)
        if ($employees instanceof LengthAwarePaginator || $employees instanceof Collection) {
            // Get the first employee from the paginator or collection
            $employee = $employees->first();

            if (isset($employee->name)) {
                return "{$employee->name} ({$employeeCode})";
            } elseif (isset($employee->employee->name)) {
                return "{$employee->employee->name} ({$employeeCode})";
            }
        } elseif (is_object($employees)) {
            // If it's a single employee object, access its properties
            return "{$employees->first_name} {$employees->last_name} ({$employeeCode})";
        }
    }

    return "";
}

function removeFirstWord($string) {
    $words = explode(' ', $string);
    array_shift($words);
    return implode(' ', $words);
}


function calculateDiscount($amount, $discount_type, $discount, $months=1)
{
    if ($discount_type == 'percentage') {
        return ($amount * $discount) / 100;
    } elseif ($discount_type == 'fixedamount') {
        return $discount * $months;
    }
    return 0;
}



function parseDateRange($dateRange)
{
    // Split the date range by the separator
    $dateRangeParts = explode(' - ', $dateRange);

    if (count($dateRangeParts) !== 2) {
        return [null, null];  // Return null if invalid range
    }

    // Trim any extra spaces from the dates
    $fromDate = trim($dateRangeParts[0]);
    $toDate = trim($dateRangeParts[1]);

    $fromDateCarbon = date_convertion($fromDate, 'Y-m-d');
    $toDateCarbon = date_convertion($toDate, 'Y-m-d');

    return [$fromDateCarbon, $toDateCarbon];
}

function gradeCalculation($gpa)
{
    if ($gpa >= "5.00") {
        return 'A+';
    } elseif ($gpa >= "4.00") {
        return 'A';
    } elseif ($gpa >= "3.50") {
        return 'A-';
    } elseif ($gpa >= "3.00") {
        return 'B';
    } elseif ($gpa >= "2.00") {
        return 'C';
    } elseif ($gpa >= "1.00") {
        return 'D';
    } else {
        return 'F';
    }
}

function gradeNameRemarks($grade_name = '')
{
    return Grade::where('name',$grade_name)->first()->remark ?? '';
}


