<?php
namespace App\Http\Controllers\Academic;
use App\Models\User;
use Illuminate\Http\Request;
use App\Models\Academic\Shift;
use App\Models\Academic\Section;
use App\Http\Controllers\Controller;
use App\Models\Academic\ClassSection;
use App\Models\Academic\StudentClass;
class AssignClassTeacherController extends Controller
{
    public function index()
    {
        //here only show the ass
        $teachers = User::where('user_type', '=', 'teacher')->pluck('name', 'id');
        $classTeachers = ClassSection::with(['studentClass','section', 'shift', 'classTeacher'])->get(); 
        // dd($classTeachers, $teachers);
        return view('pages.academic.class_teachers.index', compact('teachers', 'classTeachers'));
    }
    public function create()
    {
        $data['teachers'] = User::where('user_type', '=', 'teacher')->pluck('name', 'id');
        $data['studentClasses'] = StudentClass::with('sections')->pluck('class_name','id');
        $data['sections'] = Section::with('sections')->pluck('section_name','id');
        $data['shifts'] = Shift::with('shifts')->pluck('shift_name','id');
        $data['sections'] = [];
        return view('pages.academic.class_teachers.create', $data);
    }
    public function store(Request $request)
    { 
        $request->validate([
            'student_class_id' => 'required',
            'teacher_id' => 'required',
        ]);

        // dd($request->all());

        ClassSection::updateOrCreate(
            [
                'branch_id' => auth()->id(),
                'student_class_id' => $request->student_class_id,
                'section_id' => $request->section_id,
                'shift_id' => $request->shift_id,
            ],
            [
                'class_teacher_id' => $request->teacher_id,
            ]
        );

        return redirect()
        ->route('class_teachers.index')
        ->with('success', 'Teacher assigned successfully.');
    }

    public function show($id)
    {
        $studentClass = ClassSection::findOrFail($id);
        return view('pages.academic.class_teachers.show', compact('studentClass'));
    }
    public function edit($id)
    {
        $data['selectedClassTeacher'] = ClassSection::with(['studentClass','section', 'shift', 'classTeacher'])
            ->where('id',$id)->first();
        $data['teachers'] = User::where('user_type', '=', 'teacher')->pluck('name', 'id');
        $data['id'] = $id;
        return view('pages.academic.class_teachers.edit', $data);
    }
    public function update(Request $request, $id)
    {
        $checkExits = ClassSection::where('class_teacher_id', '=', $request->teacher_id)->where('id', '!=',$id)->first();
        if($checkExits){
            return redirect()->route('class_teachers.index')->with('warning', 'Teacher already assigned as class teacher in another class.');
        }
        ClassSection::where('student_class_id',$request->student_class_id)
            ->where('section_id',$request->section_id)
            ->update([
                'class_teacher_id'=>$request->teacher_id
            ]);
        return redirect()->route('class_teachers.index')->with('success', 'Teacher updated successfully.');
    }
    public function updateAjax(Request $request){
        $id = $request->id;
        $student_class_id = $request->class_id;
        $section_id = $request->section_id;
        $teacher_id = $request->teacher_id;
        $checkExits = ClassSection::where('class_teacher_id', '=', $teacher_id)->where('id', '!=',$id)->first();
        if($checkExits){
            return response()->json(['warning' => 'Teacher already assigned as class teacher in another class.']);
        }
        ClassSection::where('student_class_id',$student_class_id)
            ->where('section_id',$section_id)
            ->update([
                'class_teacher_id'=>$request->teacher_id
            ]);
        return response()->json(['success' => 'Teacher updated successfully.']);
    }
    public function destroy($id)
    {
        $classSection = ClassSection::findOrFail($id);
        $classSection->class_teacher_id = null;
        $classSection->save();
        return redirect()->route('class_teachers.index')->with('success', 'Teacher unassigned successfully.');
    }
}