<?php

namespace App\Http\Controllers\Academic;

use App\Http\Controllers\Controller;
use App\Models\Academic\Branch;
use App\Models\Academic\Building;
use Illuminate\Http\Request;

class BuildingController extends Controller
{
    public function index()
    {
        $branches = Branch::pluck('branch_name','id');
        $buildings = Building::with('branch')->get();
        return view('pages.academic.building.index',compact('buildings','branches'));
    }

    public function store(Request $request)
    {
        $request->validate([
            'building_name' => 'required|string|max:255',
            'branch_id' => 'required|integer',
        ]);
        $group = Building::create([
            'building_name' => $request->building_name,
            'branch_id' => $request->branch_id,
            'created_by' => auth()->id() ?? 1,
            'updated_by' => auth()->id() ?? 1,
        ]);

        return redirect(route('buildings.index'))->with('message','Building Successfully Created');
    }

    public function update(Request $request)
    {
        $request->validate([
            'building_name' => 'required|string|max:255',
            'branch_id' => 'required|integer',
        ]);
        $group = Building::where('id',$request->id)->update([
            'building_name' => $request->building_name,
            'branch_id' => $request->branch_id,
            'created_by' => auth()->id() ?? 1,
            'updated_by' => auth()->id() ?? 1,
        ]);

        return redirect(route('buildings.index'))->with('message','Building Successfully Update');
    }

    public function destroy(Building $building)
    {
        $building->delete();
        return redirect(route('buildings.index'))->with('message','Building Successfully Deleted');
    }
}
