<?php
namespace App\Http\Controllers\Academic;
use App\Http\Controllers\Controller;
use App\Models\Academic\Building;
use App\Models\Academic\BuildingFloor;
use Illuminate\Http\Request;
class BuildingFloorController extends Controller
{
    public function index()
    {
        $buildingFloors = BuildingFloor::with('building')->get();
        $buildings = Building::pluck('building_name','id');
        return view('pages.academic.building_floors.index', compact('buildingFloors','buildings'));
    }

    public function store(Request $request)
    {
        $request->validate([
            'building_id' => 'required|exists:buildings,id',
            'floor_number' => 'required',
        ]);
        BuildingFloor::create($request->all());
        return redirect()->route('building_floors.index')->with('success', 'Building Floor created successfully');
    }

    public function update(Request $request)
    {
        $request->validate([
            'building_id' => 'required|exists:buildings,id',
            'floor_number' => 'required',
            'id' => 'required',
        ]);
        BuildingFloor::where('id',$request->id)->update([
            'building_id' => $request->building_id,
            'floor_number' => $request->floor_number,
        ]);
        return redirect()->route('building_floors.index')->with('success', 'Building Floor updated successfully');
    }

    public function destroy(BuildingFloor $buildingFloor)
    {
        $buildingFloor->delete();
        return redirect()->route('building_floors.index')->with('success', 'Building Floor deleted successfully');
    }

    public function get_building_floors(Request $request){
        $building_floors = BuildingFloor::where('building_id', $request->input('building_id'))->get();
        return response()->json($building_floors,200);
    }
}