<?php

namespace App\Http\Controllers\Academic;

use Illuminate\Http\Request;
use App\Models\Academic\Branch;
use App\Models\Academic\Building;
use App\Models\Academic\ClassRoom;
use App\Http\Controllers\Controller;
use App\Models\Academic\BuildingFloor;

class BuildingSetupController extends Controller
{
    public function index(){
        $branches = Branch::pluck('branch_name','id');
        $buildings = Building::with('branch')->get();
        $class_rooms = ClassRoom::with('buildingFloor.building')->get();
        $buildings_arr = Building::pluck('building_name','id');
        $floors = BuildingFloor::pluck('floor_number','id');
        return view('pages.academic.building-setup.index',compact('buildings','branches', 'class_rooms','buildings_arr','floors'));
    }

    public function building_store(Request $request)
    {
        $request->validate([
            'building_name' => 'required|string|max:255',
            'branch_id' => 'required|integer',
        ]);
        Building::create([
            'building_name' => $request->building_name,
            'branch_id' => $request->branch_id,
            'created_by' => auth()->id() ?? 1,
            'updated_by' => auth()->id() ?? 1,
        ]);
        return redirect()->back()->with('message','Building Successfully Created');
    }

    public function building_update(Request $request)
    {
        $request->validate([
            'building_name' => 'required|string|max:255',
            'branch_id' => 'required|integer',
        ]);
        Building::where('id',$request->id)->update([
            'building_name' => $request->building_name,
            'branch_id' => $request->branch_id,
            'created_by' => auth()->id() ?? 1,
            'updated_by' => auth()->id() ?? 1,
        ]);
        return redirect()->back()->with('message','Building Successfully Update');
    }

    public function building_destroy(Building $building)
    {
        $building->delete();
        return redirect()->back()->with('message','Building Successfully Deleted');
    }

    public function class_room_store(Request $request)
    {
        $request->validate([
            'room_no' => 'required|string|max:255',
            'building_id' => 'required|integer',
            'total_seat' => 'required|integer',
        ]);
        ClassRoom::create([
            'room_no' => $request->room_no,
            'building_id' => $request->building_id,
            'building_floor_id' => $request->building_floor_id,
            'total_seat' => $request->total_seat,
            'created_by' => auth()->id(),
        ]);

        return redirect()->back()->with('message','Class Room Successfully Created');
    }
  
    public function class_room_update(Request $request)
    {
        $request->validate([
            'room_no' => 'required|string|max:255',
            'building_id' => 'required|integer',
            'total_seat' => 'required|integer',
            'id' => 'required|integer',
        ]);
        ClassRoom::where('id',$request->id)->update([
            'room_no' => $request->room_no,
            'building_id' => $request->building_id,
            'building_floor_id' => $request->building_floor_id,
            'total_seat' => $request->total_seat,
            'created_by' => auth()->id() ?? 1,
            'updated_by' => auth()->id() ?? 1,
        ]);
        return redirect()->back()->with('message','Class Room Successfully Created');
    }

    public function class_room_destroy(ClassRoom $ClassRoom)
    {
        $ClassRoom->delete();
        return redirect()->back()->with('message','Class Room Successfully Deleted');
    }

    

    
}
