<?php

namespace App\Http\Controllers\Academic;

use App\Http\Controllers\Controller;
use App\Models\Academic\Building;
use App\Models\Academic\BuildingFloor;
use App\Models\Academic\ClassRoom;
use Illuminate\Http\Request;

class ClassRoomController extends Controller
{
    public function index()
    {
        $class_rooms = ClassRoom::with('buildingFloor.building')->get();
        $buildings = Building::pluck('building_name','id');
        $floors = BuildingFloor::pluck('floor_number','id');
        return view('pages.academic.class_room.index',compact('class_rooms','buildings','floors'));
    }

    public function store(Request $request)
    {
        $request->validate([
            'room_no' => 'required|string|max:255',
            'building_id' => 'required|integer',
            'total_seat' => 'required|integer',
        ]);
        $group = ClassRoom::create([
            'room_no' => $request->room_no,
            'building_id' => $request->building_id,
            'building_floor_id' => $request->building_floor_id,
            'total_seat' => $request->total_seat,
            'created_by' => auth()->id(),
        ]);

        return redirect(route('class_rooms.index'))->with('message','Class Room Successfully Created');
    }
  
    public function update(Request $request)
    {
        $request->validate([
            'room_no' => 'required|string|max:255',
            'building_id' => 'required|integer',
            'total_seat' => 'required|integer',
            'id' => 'required|integer',
        ]);
        $group = ClassRoom::where('id',$request->id)->update([
            'room_no' => $request->room_no,
            'building_id' => $request->building_id,
            'building_floor_id' => $request->building_floor_id,
            'total_seat' => $request->total_seat,
            'created_by' => auth()->id() ?? 1,
            'updated_by' => auth()->id() ?? 1,
        ]);
        return redirect(route('class_rooms.index'))->with('message','Class Room Successfully Created');
    }

    public function destroy(ClassRoom $ClassRoom)
    {
        $ClassRoom->delete();
        return redirect(route('class_rooms.index'))->with('message','Class Room Successfully Deleted');
    }

    public function get_class_rooms(Request $request){
        $class_rooms = ClassRoom::where('building_floor_id', $request->input('building_floor_id'))->get();
        return response($class_rooms,200);
    }
}