<?php

namespace App\Http\Controllers\Academic;

use App\Http\Controllers\Controller;
use Illuminate\Http\Request;
use App\Models\Academic\Department;

class DepartmentController extends Controller
{

    public function index()
    {
        $departments = Department::all();
        return view('pages.academic.department.index', compact('departments'));
    }

    public function store(Request $request)
    {
        $request->validate([
            'name' => 'required|string|max:250',
        ]);
        $item = new Department();
        $item->name = $request->name;
        $item->save();
        return redirect()->route('department.index')->with('success', 'Added successfully.');
    }

    public function update(Request $request)
    {
        $request->validate([
            'name' => 'required|string|max:250',
        ]);
        $item = Department::findOrFail($request->id);
        $item->name = $request->name;
        $item->save();
        return redirect()->route('department.index')->with('success', 'Updated successfully.');
    }

    public function destroy($id)
    {
        $item = Department::findOrFail($id);
        $item->delete();
        return redirect()->route('department.index')->with('success', 'Deleted successfully.');
    }
}
