<?php

namespace App\Http\Controllers\Academic;

use App\Http\Controllers\Controller;
use App\Models\Academic\Group;
use Illuminate\Support\Facades\Validator;
use Illuminate\Http\Request;

class GroupController extends Controller
{
    public function index()
    {
        $groups = Group::all();
        return view('pages.academic.group.index',compact('groups'));
    }
    public function store(Request $request)
    {
        $validation = Validator::make($request->all(), [
            'group_name' => 'required|string|max:255',
        ]);

        if ($validation->fails()) {
            return back()->with('errors',$validation->errors());
        }

        $group = Group::create([
            'group_name' => $request->group_name,
            'status' => $request->status,
        ]);

        return redirect()->route('groups.index')->with('success','Group Successfully Created');
    }


    public function show(Group $group)
    {
        return response()->json(['group' => $group]);
    }

    public function update(Request $request)
    {
        $validation = Validator::make($request->all(), [
            'group_name' => 'required|string|max:255',
        ]);

        if ($validation->fails()) {
            return back()->with('errors',$validation->errors());
        }

        Group::where('id',$request->id)->update([
            'group_name' => $request->group_name,
            'status' => $request->status,
        ]);

        return redirect()->route('groups.index')->with('success','Group Successfully Updated');
    }

    public function destroy(Group $group)
    {
        $group->delete();
        return redirect()->route('groups.index')->with('danger', 'Group deleted successfully');
    }
}
