<?php

namespace App\Http\Controllers\Academic;

use App\Http\Controllers\Controller;
use App\Models\Academic\Shift;
use Illuminate\Http\Request;

class ShiftController extends Controller
{
    /**
     * Display a listing of the resource.
     */
    public function index()
    {
        $shifts = Shift::all();
        return view('pages.academic.shift.index',compact('shifts'));
    }

    /**
     * Show the form for creating a new resource.
     */
    public function create()
    {
        return view('pages.academic.shift.create');
    }

    /**
     * Store a newly created resource in storage.
     */
    public function store(Request $request)
    {
        $request->validate([
            'shift_name' => 'required|string|max:255',
            'start_time' => 'required',
            'end_time' => 'required',
        ]);
        $group = Shift::create([
            'shift_name' => $request->shift_name,
            'start_time' => $request->start_time,
            'end_time' => $request->end_time,
        ]);

        return redirect('/academic/shifts')->with('message','Shift Successfully Created');
    }

    /**
     * Display the specified resource.
     */
    public function show(Shift $shift)
    {
        return response()->json(['shift' => $shift]);
    }

    /**
     * Show the form for editing the specified resource.
     */
    public function edit(Shift $shift)
    {
        // dd($shift);
        return view('pages/academic/shift/edit',compact('shift'));
    }

    /**
     * Update the specified resource in storage.
     */
    public function update(Request $request)
    {
        $request->validate([
            'shift_name' => 'required|string|max:255',
            'start_time' => 'required',
            'end_time' => 'required',
        ]);
        $group = Shift::where('id',$request->id)->update([
            'shift_name' => $request->shift_name,
            'start_time' => $request->start_time,
            'end_time' => $request->end_time,
        ]);

        return redirect('/academic/shifts')->with('message','Shift Successfully Updated');
    }

    /**
     * Remove the specified resource from storage.
     */
    public function destroy($shift)
    {
        $shift = Shift::findOrFail($shift);
        $shift->delete();
        return redirect('/academic/shifts')->with('message','Shift Successfully Deleted');
    }
}
