<?php

namespace App\Http\Controllers\Academic;

use App\Http\Controllers\Controller;
use App\Models\Academic\ClassSection;
use App\Models\Academic\Section;
use App\Models\Academic\Shift;
use App\Models\Academic\StudentClass;
use Illuminate\Http\Request;
use Illuminate\Support\Str;

class StudentClassController extends Controller
{

    public function index()
    {
        $sections = Section::get();
        $shifts = Shift::pluck('shift_name', 'id');
        $studentClasses = StudentClass::with(['classSections.section', 'classSections.shift', 'classSections.classTeacher'])->get();
        // $studentClasses = ClassSection::with(['studentClass','section', 'shift', 'classTeacher'])->get();
        return view('pages.academic.student_class.index',compact('sections', 'shifts', 'studentClasses'));
    }

    public function create()
    {
        $sections = Section::get();
        $shifts = Shift::pluck('shift_name', 'id');
        return view('pages.academic.student_class.create', compact('sections', 'shifts'));
    }

    public function store(Request $request)
    {
        $request->validate([
            'class_name' => 'required|string|max:255|unique:student_classes,class_name',
        ]);
    
        $sections = $request->sections ?? null;
        $shift_id = $request->shift_id ?? null;
        $branch_id = auth()->user()->branch_id;
    
        $classSlug = Str::slug($request->class_name);
    
        $existClass = StudentClass::where('slug', $classSlug)->first();
    
        if (!$existClass) {
            
            $existClass = StudentClass::create([
                'class_name' => $request->class_name,
                'slug' => $classSlug,
                'created_by' => auth()->id() ?? null,
            ]);
        }
    
        $class_sections = [];
        if ($sections) {
            foreach ($sections as $section) {

                if ($shift_id) {

                    $existingSection = ClassSection::where([
                        'student_class_id' => $existClass->id,
                        'section_id' => $section,
                        'shift_id' => $shift_id,
                        'branch_id' => $branch_id,
                    ])->first();
                } else {

                    $existingSection = ClassSection::where([
                        'student_class_id' => $existClass->id,
                        'section_id' => $section,
                        'branch_id' => $branch_id,
                    ])->first();
                }
    
                if ($existingSection) {
                    continue;
                }
    
                $class_sections[] = [
                    'branch_id' => $branch_id,
                    'shift_id' => $shift_id,
                    'student_class_id' => $existClass->id,
                    'section_id' => $section,
                ];
            }
        }
    
        // Insert the new sections if there are any
        if ($class_sections) {
            ClassSection::insert($class_sections);
        }
    
        return redirect(route('student_class.index'))->with('message', 'Class and sections successfully created or updated.');
    }    
    
    public function show(StudentClass $studentClass)
    {
        // dd($studentClass);
    }

    public function edit($studentClassId)
    {
        $data['studentClass'] = StudentClass::find($studentClassId);
        $data['sections'] = Section::get();
        $data['shifts'] = Shift::pluck('shift_name', 'id');
        $data['selectedSections'] = ClassSection::where('student_class_id',$studentClassId)->pluck('section_id')->toArray();
        return view('pages.academic.student_class.edit', $data);
    }

    public function update(Request $request, StudentClass $studentClass)
    {
        $request->validate([
            'class_name' => 'required|string|max:255|unique:student_classes,class_name,' . $studentClass->id,
        ]);

        $sections = $request->sections ?? null;
        $shift_id = $request->shift_id ?? null;
        $branch_id = auth()->user()->branch_id;
    
        StudentClass::where('id', $studentClass->id)->update([
            'class_name' => $request->class_name,
            'updated_by' => auth()->id() ?? null,
        ]);
    
        $class_sections = [];
        if ($sections) {
            foreach ($sections as $section) {

                if ($shift_id) {
                    $existingSection = ClassSection::where([
                        'student_class_id' => $studentClass->id,
                        'section_id' => $section,
                        'shift_id' => $shift_id,
                        'branch_id' => $branch_id,
                    ])->first();
                } else {

                    $existingSection = ClassSection::where([
                        'student_class_id' => $studentClass->id,
                        'section_id' => $section,
                        'branch_id' => $branch_id,
                    ])->first();
                }
    
                if ($existingSection) {
                    continue;
                }
    
                $class_sections[] = [
                    'branch_id' => $branch_id,
                    'shift_id' => $shift_id,
                    'student_class_id' => $studentClass->id,
                    'section_id' => $section,
                ];
            }
        }
    
        if ($class_sections) {
            ClassSection::insert($class_sections);
        }
    
        return redirect(route('student_class.index'))->with('message', 'Class successfully updated');
    }
    

    public function destroy(StudentClass $studentClass)
    {
        ClassSection::where('student_class_id',$studentClass->id)->delete();
        $studentClass->delete();
        return redirect(route('student_class.index'))->with('message','Class Successfully Deleted');
    }
}
