<?php

namespace App\Http\Controllers\Academic;

use App\Http\Controllers\Controller;
use App\Models\Academic\ClassRoutine;
use App\Models\Academic\RoutineDetail;
use App\Models\Academic\Subject;
use App\Models\Academic\SubjectsAssign;
use App\Models\Academic\SubjectTeacher;
use App\Models\Academic\TeacherEnrollment;
use App\Models\Homework\Homework;
use App\Models\Homework\HomeworkSubmission;
use App\Models\Hsc\GroupSubject;
use App\Models\Result\ExamRecord;
use App\Models\Result\ExamRoutine;
use App\Models\Result\MarkHeadAssign;
use App\Models\StudentInfoSubjectClass;
use App\Models\Syllabus\Lesson;
use App\Models\Syllabus\LessonTopic;
use Illuminate\Http\Request;

class SubjectController extends Controller
{
    //Subjects Controller for Academic 
    public function index()
    {
        $subjects = Subject::all();
        return view('pages.academic.subject.index', compact('subjects'));
    }

    public function store(Request $request)
    {
        $subject = Subject::create($request->all());
        return redirect()->route('subjects.index')->with('success','Subject Created Successfully!');
    }

    public function show(Subject $subject)
    {
        return view('pages.academic.subject.show', compact('subject'));
    }
    public function update(Request $request)
    {
        Subject::where('id',$request->id)->update([
            'subject_name' => $request->subject_name,
            'short_name' => $request->short_name,
            'subject_code' => $request->subject_code,
            'is_optional' => $request->is_optional,
            'updated_by' => auth()->id(),
        ]);

        return redirect()->route('subjects.index')->with('success','Subject has been updated successfully!');
    }

    public function destroy(Subject $subject)
    {
        $subjectAssigns = SubjectsAssign::where('subject_id', $subject->id)->exists();
        $markHeadAssign = MarkHeadAssign::where('subject_id', $subject->id)->exists();
        $examRecord     = ExamRecord::where('subject_id', $subject->id)->exists();
        $exam_routines     = ExamRoutine::where('subject_id', $subject->id)->exists();
        $group_subjects     = GroupSubject::where('subject_id', $subject->id)->exists();
        $homework     = Homework::where('subject_id', $subject->id)->exists();
        $homework_submissions     = HomeworkSubmission::where('subject_id', $subject->id)->exists();
        $lessons     = Lesson::where('subject_id', $subject->id)->exists();
        $lesson_topics     = LessonTopic::where('subject_id', $subject->id)->exists();
        $subject_teachers     = SubjectTeacher::where('subject_id', $subject->id)->exists();
        $teacher_enrollments     = TeacherEnrollment::where('subject_id', $subject->id)->exists();
        $student_info_subject_class     = StudentInfoSubjectClass::where('subject_id', $subject->id)->exists();

        // ❌ Prevent delete if subject is already used
        if ($subjectAssigns || $markHeadAssign || $examRecord || $exam_routines || $group_subjects || $homework || $homework_submissions || $lessons || $lesson_topics || $subject_teachers || $teacher_enrollments || $student_info_subject_class) {
            return redirect()
                ->route('subjects.index')
                ->with('error', 'This subject cannot be deleted because it is already in use.');
        }

        // ✅ Safe to delete
        $subject->delete();

        return redirect()
            ->route('subjects.index')
            ->with('success', 'Subject has been deleted successfully!');
    }



    public function getSubjectByClassID(Request $request)
    {
        $userType = auth()->user()->user_type;
    
        if ($userType == 'teacher') {
            // Get class routine IDs for the specified class
            $classRoutines = ClassRoutine::where('student_class_id', $request->student_class_id)
                ->pluck('id')
                ->toArray();
    
            // Get subject IDs for the teacher's routines
            $subjectIds = RoutineDetail::whereIn('class_routine_id', $classRoutines)
                ->where('teacher_id', auth()->user()->id)
                ->distinct()
                ->pluck('subject_id')
                ->toArray();
    
            // Get unique subjects assigned to the teacher
            $subjects = SubjectsAssign::with('subject')
                ->where('student_class_id', $request->student_class_id)
                ->whereIn('subject_id',  $subjectIds)
                ->distinct()
                ->get();
        } else {
            // Get unique subjects assigned to the student class
            $subjects = SubjectsAssign::with('subject')
                ->where('student_class_id', $request->student_class_id)
                ->distinct() // Ensure unique subjects
                ->get();
            // $subjects = SubjectsAssign::with('subject')
            // ->where('student_class_id', $request->student_class_id)
            // ->when(!empty($request->group_id), function ($query) use ($request) {
            //     $query->where('group_id', $request->group_id);
            // })
            // ->distinct()
            // ->get();

        }

        // dd($request->all(), $subjects);
    
        return response()->json($subjects, 200);
    }
}
