<?php

namespace App\Http\Controllers\Academic;

use Illuminate\Http\Request;
use App\Models\Academic\Subject;
use App\Http\Controllers\Controller;
use App\Models\Academic\SubjectsAssign;

class SubjectSetupController extends Controller
{
    public function index()
    {
        $subjects = Subject::all();
        $subjectsAssigns = SubjectsAssign::with('studentClass', 'subject')->orderBy('student_class_id')->get()->groupBy('student_class_id');
        return view('pages.academic.subject-setup.index',compact('subjects','subjectsAssigns'));
    }

    public function subject_store(Request $request)
    {

        $request->validate([
            'subject_name' => 'required|string|max:255|unique:subjects,subject_name',
        ]);
        Subject::create($request->all());
        return redirect()->back()->with('success','Subject Created Successfully!');
    }

    public function subject_update(Request $request)
    {
        $request->validate([
            'subject_name' => 'required|string|max:255|unique:subjects,subject_name,' . $request->id,
        ]);

        Subject::where('id',$request->id)->update([
            'subject_name' => $request->subject_name,
            'short_name' => $request->short_name,
            'subject_code' => $request->subject_code,
            'is_optional' => $request->is_optional,
            'updated_by' => auth()->id(),
        ]);
        return redirect()->back()->with('success','Subject has been updated successfully!');
    }
}
