<?php

namespace App\Http\Controllers\Academic;

use App\Http\Controllers\Controller;
use App\Models\Academic\ClassSection;
use App\Models\Academic\StudentClass;
use App\Models\User;
use Illuminate\Http\Request;
use Illuminate\Support\Facades\DB;

class SubjectTeacherController extends Controller
{
    public function index()
    {
        $classTeachers = ClassSection::with('studentClass','section','classTeacher')->get();
    
        return view('pages.academic.subject-teachers.index', compact('classTeachers'));
    }

    public function create()
    {
        $teachers = User::where('user_type', 'teacher')
                ->select(DB::raw("CONCAT(first_name, ' ', last_name) AS name"), 'id')
                ->get()
                ->pluck('name', 'id');
        $studentClasses = StudentClass::with('sections')->pluck('class_name','id');
        $sections = [];
        return view('pages.academic.subject-teachers.create', compact('teachers','studentClasses','sections'));
    }

    public function store(Request $request)
    { 
        ClassSection::where('student_class_id',$request->student_class_id)
                    ->where('section_id',$request->section_id)
                    ->update(['class_teacher_id'=>$request->teacher_id]);
        return redirect()->route('subject-teachers.index')->with('success', 'Teacher assigned successfully.');
    }

    public function show($id)
    {
        $studentClass = ClassSection::findOrFail($id);
        return view('pages.academic.subject-teachers.show', compact('studentClass'));
    }

    public function edit($id)
    {
        $selectedClassTeacher = ClassSection::findOrFail($id);
        $teachers = User::where('user_type', 'teacher')
                ->select(DB::raw("CONCAT(first_name, ' ', last_name) AS name"), 'id')
                ->get()
                ->pluck('name', 'id');
        $studentClasses = StudentClass::with('sections')->pluck('class_name','id');
        $sections = [];
        return view('pages.academic.subject-teachers.edit', compact('selectedClassTeacher', 'teachers', 'studentClasses', 'sections', 'id'));
    }

    public function update(Request $request, $id)
    {
        $request->validate([
            'teacher_id' => 'required|exists:users,id',
        ]);

        ClassSection::where('student_class_id',$request->student_class_id)
        ->where('section_id',$request->section_id)
        ->update(['class_teacher_id'=>$request->teacher_id]);

        return redirect()->route('subject-teachers.index')->with('success', 'Teacher updated successfully.');
    }

    public function destroy($id)
    {
        $class = StudentClass::findOrFail($id);
        $class->teacher_id = null;
        $class->save();

        return redirect()->route('subject-teachers.index')->with('success', 'Teacher unassigned successfully.');
    }
}
