<?php
namespace App\Http\Controllers\Academic;
use Illuminate\Http\Request;
use App\Models\Academic\Group;
use App\Models\Academic\Subject;
use App\Models\Result\ExamRecord;
use Illuminate\Support\Facades\DB;
use App\Http\Controllers\Controller;
use App\Models\Academic\StudentClass;
use App\Models\Result\MarkHeadAssign;
use App\Models\Academic\SubjectsAssign;
class SubjectsAssignController extends Controller
{
    public function index()
    {
        $subjectsAssigns = SubjectsAssign::with('studentClass', 'subject', 'group')
        ->orderBy('student_class_id')
        ->orderBy('group_id')
        ->get()
        ->groupBy(function ($item) {
            $classId = $item->student_class_id;
            $groupId = $item->group_id ?? 'no-group';
            return $classId . '-' . $groupId;
        });
        return view('pages.academic.subjects_assigns.index', compact('subjectsAssigns'));
    }
    public function create()
    {
        $classes = StudentClass::all();
        $groups = Group::all();
        $subjects = Subject::all();
        $mark_heads = DB::table('mark_heads')->get();
        return view('pages.academic.subjects_assigns.create', compact('classes',  'groups', 'subjects','mark_heads'));
    }
    public function store(Request $request)
    {
        $classId = $request->input('class_id');
        $subjectIds = $request->input('subjects');
        $groupId = $request->input('group_id');
        $check_subject = SubjectsAssign::where('student_class_id',$classId)->where('group_id', $groupId)->get();
        $query = SubjectsAssign::where('student_class_id', $classId);
        if ($groupId === null) {
            $query->whereNull('group_id');
        } else {
            $query->where('group_id', $groupId);
        }
        $check_subject = $query->get();
        if($check_subject->isEmpty()){
            foreach ($subjectIds as $subjectId) {
                if(!empty($subjectId)){
                    SubjectsAssign::create([
                        'student_class_id' => $classId,
                        'subject_id' => $subjectId,
                        'group_id' => $groupId,
                    ]);
                }
            }
            return redirect()->route('subjects_assigns.index')->with('success', 'Subject assign created successfully');
        }else{
            return redirect()->route('subjects_assigns.index')->with('warning', 'Subject already assign to this class.');
        }
    }
    public function show($id)
    {
        $subjectsAssign = SubjectsAssign::findOrFail($id);
        return view('subjects_assigns.show', compact('subjectsAssign'));
    }
    public function edit($classId )
    {
        $classes = StudentClass::all();
        $groups = Group::all();
        $subjects = Subject::all();
        $assignedSubjects = SubjectsAssign::where('student_class_id', $classId)->pluck('subject_id')->toArray();
        $groupId = SubjectsAssign::where('student_class_id', $classId)->first()->group_id;
        return view('pages.academic.subjects_assigns.edit', compact('classId','groups', 'groupId', 'assignedSubjects','classes', 'subjects'));
    }
    public function update(Request $request, $classId)
    {   
        $subjectIds = $request->input('subjects');
        $groupId = $request->input('group_id');
        SubjectsAssign::where('student_class_id',$classId)->delete();
        foreach ($subjectIds as $subjectId) {
            if(!empty($subjectId)){
                SubjectsAssign::create([
                    'student_class_id' => $classId,
                    'subject_id' => $subjectId,
                    'group_id' => $groupId,
                ]);
            }
        }
        return redirect()->route('subjects_assigns.index')->with('success', 'Subject assign updated successfully');
    }
    public function destroy22($classId )
    {
        // Step 1: Get subject IDs for this class (+  if exists)
        $subjectIds = SubjectsAssign::where('student_class_id', $classId)
            ->pluck('subject_id')
            ->toArray();
        // Step 2: Check if subjects are already used anywhere
        $usedInMarkHead = MarkHeadAssign::whereIn('subject_id', $subjectIds)->exists();
        $usedInExam     = ExamRecord::whereIn('subject_id', $subjectIds)->exists();
        // dd($usedInMarkHead,$usedInExam);
        if($usedInExam){
            return redirect()
                ->route('subjects_assigns.index')
                ->with('error', 'Cannot delete. One or more subjects are already in use.');
        }
        // Step 3: Delete subject assigns
        SubjectsAssign::where('student_class_id',$classId)->delete();
        return redirect()
            ->route('subjects_assigns.index')
            ->with('success', 'Subject assign deleted successfully');
    }
    public function destroy($classId )
    {
        SubjectsAssign::where('student_class_id',$classId)->delete();
        return redirect()->route('subjects_assigns.index')->with('success', 'Subject assign deleted successfully');
    }
}