<?php

namespace App\Http\Controllers\Accounting;
use App\Http\Controllers\Controller;
use App\Constants\Accounting;
use Illuminate\Http\Request;
use App\Models\Accounting\BankAccount;
class BankAccountController extends Controller
{
    /**
     * Display a listing of the resource.
     */
    public function index()
    {
        $accounts = BankAccount::all();
        $types = Accounting::BANK_ACCOUNT_TYPE;
        return view('pages.accounting.bank_account.index',compact('accounts','types'));
    }

    /**
     * Store a newly created resource in storage.
     */
    public function store(Request $request)
    {
        $request->validate([
            'account_type' => 'required|string|max:255',
            'account_name' => 'required|string|max:255',
            'account_number' => 'required|integer',
            'branch_address' => 'required|string|max:255',
            'bank_name' => 'required|string|max:255',
            'contact_number' => 'integer',
        ]);
        $bankaccount = new BankAccount();
        $bankaccount->account_type = $request->account_type;
        $bankaccount->account_name = $request->account_name;
        $bankaccount->account_number = $request->account_number;
        $bankaccount->branch_address = $request->branch_address;
        $bankaccount->bank_name = $request->bank_name;
        $bankaccount->contact_number = $request->contact_number;
        $bankaccount->opening_date = store_date_format($request->opening_date);
        $bankaccount->created_by = auth()->id();
        $bankaccount->save();
        return redirect()->route('bank_account.index')->with('success', 'Bank Account created successfully.');
    }

    /**
     * Update the specified resource in storage.
     */
    public function update(Request $request)
    {
        $bankaccount = BankAccount::findOrFail($request->id);
        $request->validate([
            'account_type' => 'required|string|max:255',
            'account_name' => 'required|string|max:255',
            'id' => 'required|integer',
            'account_number' => 'required|integer',
            'branch_address' => 'required|string|max:255',
            'bank_name' => 'required|string|max:255',
            'contact_number' => 'integer',
        ]);

        $bankaccount->account_type = $request->account_type;
        $bankaccount->account_name = $request->account_name;
        $bankaccount->account_number = $request->account_number;
        $bankaccount->branch_address = $request->branch_address;
        $bankaccount->bank_name = $request->bank_name;
        $bankaccount->contact_number = $request->contact_number;
        $bankaccount->opening_date = store_date_format($request->opening_date);
        $bankaccount->updated_by = auth()->id();
        $bankaccount->save();
        return redirect()->route('bank_account.index')->with('success', 'Bank Account updated successfully.');
    }

    /**
     * Remove the specified resource from storage.
     */
    public function destroy(string $id)
    {
        $bankaccount = BankAccount::findOrFail($id);
        $bankaccount->delete();
        return redirect()->route('bank_account.index')->with('success', 'Bank Account deleted successfully.');
    }
}
