<?php

namespace App\Http\Controllers\Accounting;

use App\Services\FileUploadService;
use App\Http\Controllers\Controller;
use Illuminate\Http\Request;
use App\Constants\Accounting;
use App\Models\Accounting\BankAccount;
use App\Models\Accounting\BankDeposit;
use App\Models\Accounting\AccountingHead;
class BankDepositController extends Controller
{

    public function index()
    {
        $accountingHeads = AccountingHead::where('type', Accounting::INCOME)->pluck('name', 'id');
        $bankAccounts = BankAccount::pluck('branch_address', 'id');
        $deposits = BankDeposit::all();
        $types = Accounting::BANK_ACCOUNT_TYPE;
        return view('pages.accounting.bank_deposit.index', compact('deposits', 'accountingHeads', 'bankAccounts'));
    }

    public function store(Request $request, FileUploadService $fileUploadService)
    {
        $request->validate([
            'bank_account_id' => 'required',
            'amount' => 'required|integer',
            'transaction_id' => 'string|max:255',
        ]);
        $deposit = new BankDeposit();
        $deposit->bank_account_id = $request->bank_account_id;
        $deposit->amount = $request->amount;
        $deposit->transaction_id = $request->transaction_id;
        $deposit->check_number = $request->check_number;
        $deposit->date = store_date_format($request->date);
        $deposit->note = $request->note;
        $deposit->created_by = auth()->id();
        if ($request->hasFile('attachment')) {
            $file = $request->file('attachment');
            $attachment = $fileUploadService->upload($file, 'uploads/accounting/deposit');
            $deposit->attachment = $attachment ?? null;
        }
        $deposit->save();
        return redirect()->route('bank_deposit.index')->with('success', 'Bank Deposit created successfully.');
    }

    public function update(Request $request, FileUploadService $fileUploadService)
    {
        $request->validate([
            'id' => 'required',
            'bank_account_id' => 'required',
            'amount' => 'required|integer',
            'transaction_id' => 'string|max:255',
        ]);
        $deposit = BankDeposit::findOrFail($request->id);
        $deposit->bank_account_id = $request->bank_account_id;
        $deposit->amount = $request->amount;
        $deposit->transaction_id = $request->transaction_id;
        $deposit->check_number = $request->check_number;
        $deposit->date = store_date_format($request->date);
        $deposit->note = $request->note;
        $deposit->updated_by = auth()->id();
        if ($request->hasFile('attachment')) {
            $file = $request->file('attachment');
            $attachment = $fileUploadService->upload($file, 'uploads/accounting/deposit', $deposit->attachment);
            $deposit->attachment = $attachment ?? null;
        }
        $deposit->save();
        return redirect()->route('bank_deposit.index')->with('success', 'Bank Deposit updated successfully.');
    }

    public function destroy(string $id, FileUploadService $fileUploadService)
    {
        $deposit = BankDeposit::findOrFail($id);
        if ($deposit) {
            $fileUploadService->delete($deposit->attachment);
        }
        $deposit->delete();
        return redirect()->route('bank_deposit.index')->with('success', 'Bank Deposit deleted successfully.');
    }
}
