<?php

namespace App\Http\Controllers\Accounting;
use App\Http\Controllers\Controller;
use App\Services\FileUploadService;
use Illuminate\Http\Request;
use App\Constants\Accounting;
use App\Models\Accounting\BankAccount;
use App\Models\Accounting\BankWithdraw;
use App\Models\Accounting\AccountingHead;
class BankWithdrawController extends Controller
{
    /**
     * Display a listing of the resource.
     */
    public function index()
    {
        $accountingHeads = AccountingHead::where('type', Accounting::EXPENSE)->pluck('name', 'id');
        $bankAccounts = BankAccount::pluck('branch_address', 'id');
        $withdraws = BankWithdraw::all();
        return view('pages.accounting.bank_withdraw.index',compact('withdraws','accountingHeads','bankAccounts'));
    }

    /**
     * Store a newly created resource in storage.
     */
    public function store(Request $request, FileUploadService $fileUploadService)
    {
        $request->validate([
            'bank_account_id' => 'required',
            'amount' => 'required|integer',
            'transaction_id' => 'string|max:255',
        ]);
        $withdraw = new BankWithdraw();
        $withdraw->bank_account_id = $request->bank_account_id;
        $withdraw->amount = $request->amount;
        $withdraw->transaction_id = $request->transaction_id;
        $withdraw->check_number = $request->check_number;
        $withdraw->date = store_date_format($request->date);
        $withdraw->note = $request->note;
        $withdraw->created_by = auth()->id();
        if ($request->hasFile('attachment')) {
            $file = $request->file('attachment');
            $attachment = $fileUploadService->upload($file, 'uploads/accounting/withdraw');
            $withdraw->attachment = $attachment ?? null;
        }
        $withdraw->save();
        return redirect()->route('bank_withdraw.index')->with('success', 'Bank Withdraw created successfully.');
    }
    /**
     * Update the specified resource in storage.
     */
    public function update(Request $request, FileUploadService $fileUploadService)
    {
        $request->validate([
            'id' => 'required',
            'bank_account_id' => 'required',
            'amount' => 'required|integer',
            'transaction_id' => 'string|max:255',
        ]);
        $withdraw = BankWithdraw::findOrFail($request->id);
        $withdraw->bank_account_id = $request->bank_account_id;
        $withdraw->amount = $request->amount;
        $withdraw->transaction_id = $request->transaction_id;
        $withdraw->check_number = $request->check_number;
        $withdraw->date = store_date_format($request->date);
        $withdraw->note = $request->note;
        $withdraw->updated_by = auth()->id();
        if ($request->hasFile('attachment')) {
            $file = $request->file('attachment');
            $attachment = $fileUploadService->upload($file, 'uploads/accounting/withdraw',$withdraw->attachment);
            $withdraw->attachment = $attachment ?? null;
        }
        $withdraw->save();
        return redirect()->route('bank_withdraw.index')->with('success', 'Bank Withdraw updated successfully.');
    }

    /**
     * Remove the specified resource from storage.
     */
    public function destroy(string $id, FileUploadService $fileUploadService)
    {
        $withdraw = BankWithdraw::findOrFail($id);

        if($withdraw){
            $fileUploadService->delete($withdraw->attachment);
         }
        $withdraw->delete();
        return redirect()->route('bank_withdraw.index')->with('success', 'Bank Withdraw deleted successfully.');
    }
}
