<?php

namespace App\Http\Controllers\Accounting;

use App\Http\Controllers\Controller;
use App\Models\Accounting\CheckBook;
use Illuminate\Http\Request;
class CheckBookController extends Controller
{
    public function index()
    {
        $checkBooks = CheckBook::all();
        return view('pages.accounting.check_books.index', compact('checkBooks'));
    }

    public function store(Request $request)
    {
        $request->validate([
            'name' => 'required|string',
            'account_no' => 'required|string',
            'routing_no' => 'required|string',
            'total_page' => 'required|string',
        ]);
        $checkBook = new CheckBook();
        $checkBook->name = $request->input('name');
        $checkBook->account_no = $request->input('account_no');
        $checkBook->routing_no = $request->input('routing_no');
        $checkBook->total_page = $request->input('total_page');
        $checkBook->save();
        return redirect()->route('check-books.index')->with('success', 'Check book created successfully!');
    }

    public function update(Request $request)
    {
        $request->validate([
            'id' => 'required',
            'name' => 'required|string',
            'account_no' => 'required|string',
            'routing_no' => 'required|string',
            'total_page' => 'required|string',
        ]);

        $checkBook = CheckBook::find($request->id);
        $checkBook->name = $request->input('name');
        $checkBook->account_no = $request->input('account_no');
        $checkBook->routing_no = $request->input('routing_no');
        $checkBook->total_page = $request->input('total_page');
        $checkBook->save();
        return redirect()->route('check-books.index')->with('success', 'Check book updated successfully!');
    }

    public function destroy($id)
    {
        $checkBook = CheckBook::find($id);
        $checkBook->delete();
        return redirect()->route('check-books.index')->with('success', 'Check book deleted successfully!');
    }
}
