<?php

namespace App\Http\Controllers\Accounting;

use App\Constants\Accounting;
use App\Http\Controllers\Controller;
use App\Models\Accounting\AccountingHead;
use App\Models\Accounting\Expense;
use App\Services\FileUploadService;
use Illuminate\Http\Request;

class ExpenseController extends Controller
{
    public function index()
    {
        $this->authorize('accounting.expense.view');
        $expenses = Expense::get();
        $expenseHeads = AccountingHead::where('type', Accounting::EXPENSE)->pluck('name', 'id');
        return view('pages.accounting.expense.index', compact('expenses', 'expenseHeads'));
    }

    public function create()
    {
        $this->authorize('accounting.expense.create');
        $accountingHeads = AccountingHead::where('type', Accounting::EXPENSE)->pluck('name', 'id');
        return view('pages.accounting.expense.create', compact('accountingHeads'));
    }

    public function store(Request $request, FileUploadService $fileUploadService)
    {
        $this->authorize('accounting.expense.create');
        $request->validate([
            'accounting_head_id' => 'required',
            'expense_date' => 'required',
            'amount' => 'required',
        ]);
        $expense = new Expense();
        // $expense->invoice_no = $request->invoice_no;
        $expense->branch_id = auth()->user()->branch_id;
        $expense->accounting_head_id = $request->accounting_head_id;
        $expense->expense_date = store_date_format($request->expense_date);
        $expense->amount = $request->amount;
        $expense->description = $request->description ?? null;
        if ($request->hasFile('attachment')) {
            $file = $request->file('attachment');
            $attachment = $fileUploadService->upload($file, 'uploads/accounting/expense');
            $expense->attachment = $attachment ?? null;
        }
        $expense->payment_method = $request->payment_method ?? null;
        $expense->save();
        return redirect()->route('expense.index')->with('success', 'Expense created successfully.');
    }

    public function edit($id)
    {
        $this->authorize('accounting.expense.edit');
        $expense = Expense::findOrFail($id);
        return view('pages.accounting.expense.edit', compact('expense'));
    }

    public function show($id)
    {
        $this->authorize('accounting.expense.edit');
        $expense = Expense::findOrFail($id);
        return view('pages.accounting.expense.edit', compact('expense'));
    }

    public function update(Request $request, FileUploadService $fileUploadService)
    {
        $this->authorize('accounting.expense.edit');
        $request->validate([
            'id' => 'required',
            'accounting_head_id' => 'required',
            'expense_date' => 'required',
            'amount' => 'required',
        ]);
        $expense = Expense::findOrFail($request->id);
        // $expense->invoice_no = $request->invoice_no;
        $expense->branch_id = auth()->user()->branch_id;
        $expense->accounting_head_id = $request->accounting_head_id;
        $expense->expense_date = store_date_format($request->expense_date);
        $expense->amount = $request->amount;
        $expense->description = $request->description ?? null;
        if ($request->hasFile('attachment')) {
            $file = $request->file('attachment');
            $attachment = $fileUploadService->upload($file, 'uploads/accounting/expense', $expense->attachment);
            $expense->attachment = $attachment ?? null;
        }
        $expense->payment_method = $request->payment_method ?? null;
        $expense->save();
        return redirect()->route('expense.index')->with('success', 'Expense updated successfully.');
    }

    public function destroy($id)
    {
        $this->authorize('accounting.expense.delete');
        $expense = Expense::findOrFail($id);
        $expense->delete();
        return redirect()->route('expense.index')->with('success', 'Expense deleted successfully.');
    }

    public function print($id)
    {
        $this->authorize('accounting.expense.view');
        $expense = Expense::with('accountingHead')->findOrFail($id);
        return view('pages.accounting.expense.print', compact('expense'));
    }
}
