<?php

namespace App\Http\Controllers\Accounting;

use App\Http\Controllers\Controller;
use App\Models\Accounting\FeeDiscount;
use Illuminate\Http\Request;

class FeeDiscountController extends Controller
{
    public function index()
    {
        $feeDiscounts = FeeDiscount::all();
        return view('pages.accounting.fee_discounts.index', compact('feeDiscounts'));
    }

    public function store(Request $request)
    {
        $request->validate([
            'title' => 'required|string|max:255',
            'discount_code' => 'required|string|max:255|unique:fee_discounts',
            'is_percentage' => 'boolean',
            'percentage' => 'nullable|integer|min:0|max:100|required_if:is_percentage,true',
            'amount' => 'nullable|numeric|required_if:is_percentage,false',
            'note' => 'nullable|string',
        ]);

        FeeDiscount::create($request->all());
        return redirect()->route('fee_discounts.index')->with('success', 'Fee Discount created successfully.');
    }

    public function update(Request $request, $id)
    {
        $feeDiscount = FeeDiscount::findOrFail($id);

        $request->validate([
            'title' => 'required|string|max:255',
            'discount_code' => 'required|string|max:255|unique:fee_discounts,discount_code,' . $feeDiscount->id,
            'is_percentage' => 'boolean',
            'percentage' => 'nullable|integer|min:0|max:100|required_if:is_percentage,true',
            'amount' => 'nullable|numeric|required_if:is_percentage,false',
            'note' => 'nullable|string',
        ]);

        $feeDiscount->update($request->all());
        return redirect()->route('fee_discounts.index')->with('success', 'Fee Discount updated successfully.');
    }

    public function destroy($id)
    {
        $feeDiscount = FeeDiscount::findOrFail($id);
        $feeDiscount->delete();
        return redirect()->route('fee_discounts.index')->with('success', 'Fee Discount deleted successfully.');
    }


    public function assignDiscount(){
        return view('pages.accounting.fee_discounts.index', compact('feeDiscounts'));
    }

}
