<?php

namespace App\Http\Controllers\Accounting;

use App\Http\Controllers\Controller;
use App\Models\Accounting\FeeFine;
use Illuminate\Http\Request;

class FeeFineController extends Controller
{
    public function index()
    {
        $feeFines = FeeFine::all();
        return view('pages.accounting.fee_fine.index', compact('feeFines'));
    }

    public function store(Request $request)
    {
        $request->validate([
            'title' => 'required|string|max:255',
            'discount_code' => 'required|string|max:255|unique:fee_fines',
            'is_percentage' => 'boolean',
            'percentage' => 'nullable|integer|min:0|max:100|required_if:is_percentage,true',
            'amount' => 'nullable|numeric|required_if:is_percentage,false',
            'note' => 'nullable|string',
        ]);

        FeeFine::create($request->all());
        return redirect()->route('fee_fines.index')->with('success', 'Fee Fine created successfully.');
    }

    public function update(Request $request, $id)
    {
        $feeFine = FeeFine::findOrFail($id);

        $request->validate([
            'title' => 'required|string|max:255',
            'discount_code' => 'required|string|max:255|unique:fee_fines,discount_code,' . $feeFine->id,
            'is_percentage' => 'boolean',
            'percentage' => 'nullable|integer|min:0|max:100|required_if:is_percentage,true',
            'amount' => 'nullable|numeric|required_if:is_percentage,false',
            'note' => 'nullable|string',
        ]);

        $feeFine->update($request->all());
        return redirect()->route('fee_fines.index')->with('success', 'Fee Fine updated successfully.');
    }

    public function destroy($id)
    {
        $feeFine = FeeFine::findOrFail($id);
        $feeFine->delete();
        return redirect()->route('fee_fines.index')->with('success', 'Fee Fine deleted successfully.');
    }
}
