<?php

namespace App\Http\Controllers\Accounting;

use App\Constants\Accounting;
use App\Http\Controllers\Controller;
use App\Models\Accounting\AccountingHead;
use App\Models\Accounting\Income;
use App\Services\FileUploadService;
use Illuminate\Http\Request;
class IncomeController extends Controller
{
    public function index()
    {
        $this->authorize('accounting.income.view');
        $incomes = Income::get();
        $incomeHeads = AccountingHead::where('type', Accounting::INCOME)->pluck('name', 'id');  
        return view('pages.accounting.income.index', compact('incomes', 'incomeHeads'));
    }

    public function create()
    {
        $this->authorize('accounting.income.create');
        $accountingHeads = AccountingHead::all();
        return view('pages.accounting.income.create', compact('accountingHeads'));
    }

    public function store(Request $request, FileUploadService $fileUploadService)
    {
        $this->authorize('accounting.income.create');
        $income = new Income();
        $income->invoice_no = $this->getInvoiceNo();
        $income->branch_id = auth()->user()->branch_id;
        $income->accounting_head_id = $request->accounting_head_id;
        $income->income_date = store_date_format($request->income_date);
        $income->amount = $request->amount;
        $income->description = $request->description ?? null;
        if ($request->hasFile('attachment')) {
            $file = $request->file('attachment');
            $attachment = $fileUploadService->upload($file, 'uploads/accounting/income');
            $income->attachment = $attachment ?? null;
        }
        $income->payment_method = $request->payment_method ?? null;
        $income->save();
        return redirect()->route('income.index')->with('success', 'Income created successfully.');
    }

    public function edit($id)
    {
        $this->authorize('accounting.income.edit');
        $income = Income::findOrFail($id);
        return view('pages.accounting.income.edit', compact('income'));
    }

    public function show($id)
    {
        $this->authorize('accounting.income.edit');
        $income = Income::findOrFail($id);
        return view('pages.accounting.income.edit', compact('income'));
    }

    public function update(Request $request, FileUploadService $fileUploadService)
    {
        $this->authorize('accounting.income.edit');
        $request->validate([
            'id' => 'required',
        ]);
        $income = Income::findOrFail($request->id);
        $income->branch_id = auth()->user()->branch_id;
        $income->accounting_head_id = $request->accounting_head_id;
        $income->income_date = store_date_format($request->income_date);
        $income->amount = $request->amount;
        $income->description = $request->description ?? null;
        if ($request->hasFile('attachment')) {
            $file = $request->file('attachment');
            $attachment = $fileUploadService->upload($file, 'uploads/accounting/income', $income->attachment);
            $income->attachment = $attachment ?? null;
        }
        $income->payment_method = $request->payment_method ?? null;
        $income->save();

        return redirect()->route('income.index')->with('success', 'Income updated successfully.');
    }

    public function destroy($id)
    {
        $this->authorize('accounting.income.delete');
        $income = Income::findOrFail($id);
        $income->delete();

        return redirect()->route('income.index')->with('success', 'Income deleted successfully.');
    }

    public function print($id)
    {
        $this->authorize('accounting.income.view');
        $income = Income::with('accountingHead')->findOrFail($id);
        return view('pages.accounting.income.print', compact('income'));
    }

    public function getInvoiceNo()
    {
        $branch_id = auth()->user()->branch_id;
        $invoice_no = date('Ymd').'-'.$branch_id.'-'.str_pad(Income::count() + 1, 4, '0', STR_PAD_LEFT);
        return $invoice_no;
    }
}
