<?php
namespace App\Http\Controllers\Accounting;

use App\Http\Controllers\Controller;
use App\Models\Accounting\IncomeItem;
use App\Models\Accounting\AccountingHead;
use Illuminate\Http\Request;

class IncomeItemController extends Controller
{
    public function index()
    {
        $items = IncomeItem::with('incomeHead')->get();
        return view('pages.accounting.income-item.index', compact('items'));
    }

    public function create()
    {
        $incomeHeads = AccountingHead::where('type', 'income')->get();
        return view('pages.accounting.income-item.create', compact('incomeHeads'));
    }

    public function store(Request $request)
    {
        $request->validate([
            'name' => 'required|string|max:255',
            'description' => 'nullable|string',
            'income_head_id' => 'required|exists:accounting_heads,id',
        ]);

        IncomeItem::create($request->all());
        return redirect()->route('income-item.index')->with('success', 'Income Item created successfully.');
    }

    public function edit(IncomeItem $incomeItem)
    {
        $incomeHeads = AccountingHead::where('type', 'income')->get();
        return view('pages.accounting.income-item.edit', compact('incomeItem', 'incomeHeads'));
    }

    public function update(Request $request, IncomeItem $incomeItem)
    {
        $request->validate([
            'name' => 'required|string|max:255',
            'description' => 'nullable|string',
        ]);

        $incomeItem->update($request->all());
        return redirect()->route('income-item.index')->with('success', 'Income Item updated successfully.');
    }

    public function destroy(IncomeItem $incomeItem)
    {
        $incomeItem->delete();
        return redirect()->route('income-item.index')->with('success', 'Income Item deleted successfully.');
    }
}