<?php

namespace App\Http\Controllers\Accounting;

use App\Constants\Status;
use Illuminate\Http\Request;
use App\Models\Academic\Group;
use App\Models\Academic\Shift;
use App\Models\Academic\Section;
use App\Models\Student\StudentInfo;
use App\Http\Controllers\Controller;
use App\Models\Academic\StudentClass;
use App\Models\Accounting\StudentDiscount;

class StudentDiscountController extends Controller
{
    public function index()
    {
        $this->authorize('accounting.fees-discount.view');
        $student_class_id = '';
        $section_id = '';
        $group_id = '';
        $shift_id = '';
        $studentClasses = StudentClass::pluck('class_name', 'id');
        $sections = Section::pluck('section_name', 'id');
        $groups = Group::pluck('group_name', 'id');
        $shifts = Shift::pluck('shift_name', 'id');

        return view('pages.accounting.student_discount.index', compact('studentClasses', 'sections', 'groups', 'shifts', 'student_class_id', 'section_id', 'group_id', 'shift_id'));
    }

    public function create()
    {
        $this->authorize('accounting.fees-discount.view');
        $tab = 'search';
        $student_class_id = '';
        $section_id = '';
        $group_id = '';
        $shift_id = '';
        $studentClasses = StudentClass::pluck('class_name', 'id');
        $sections = Section::pluck('section_name', 'id');
        $groups = Group::pluck('group_name', 'id');
        $shifts = Shift::pluck('shift_name', 'id');
        return view('pages.accounting.student_discount.create', compact('tab', 'studentClasses', 'sections', 'groups', 'shifts', 'student_class_id', 'section_id', 'group_id', 'shift_id'));
    }

    public function search(Request $request)
    {
        $tab = $request->tab;
        $student_name = $request->student_name;
        $student_id_no = $request->student_id_no;
        $student_class_id = $request->student_class_id;
        $section_id = $request->section_id;
        $group_id = $request->group_id;
        $shift_id = $request->shift_id;

        $students = StudentInfo::query();
        $previous_discount = StudentDiscount::query();
        $previous_discount_note = StudentDiscount::query();
        // dd($request->all());

        if (!empty($student_id_no)) {
            $students->where('student_id_no', $request->student_id_no);
            $students = $students->get();
            $discount_data = $previous_discount->where('student_id', $students[0]->id);
            $previous_discount = $discount_data->pluck('amount', 'student_id')->toArray();
            $previous_discount_note = $previous_discount_note->pluck('note', 'student_id')->toArray();
        } else {
            if ($request->has('student_class_id')) {
                $students->where('student_class_id', $request->input('student_class_id'));
                $previous_discount->where('class_id', $request->input('student_class_id'));
                $previous_discount_note->where('class_id', $request->input('student_class_id'));
            }

            if (!empty($section_id)) {
                $students->where('section_id', $request->input('section_id'));
                $previous_discount->where('section_id', $request->input('section_id'));
                $previous_discount_note->where('section_id', $request->input('section_id'));
            }

            if (!empty($group_id)) {
                $students->where('group_id', $request->input('group_id'));
                $previous_discount->where('group_id', $request->input('group_id'));
                $previous_discount_note->where('group_id', $request->input('group_id'));
            }

            if (!empty($shift_id)) {
                $students->where('shift_id', $request->input('shift_id'));
                $previous_discount->where('shift_id', $request->input('shift_id'));
                $previous_discount_note->where('shift_id', $request->input('shift_id'));
            }

            $students = $students->where('status', '!=', Status::GRADUATED)->orderBy('class_roll', 'ASC')->get();
            $previous_discount = $previous_discount->pluck('amount', 'student_id')->toArray();
            $previous_discount_note = $previous_discount_note->pluck('note', 'student_id')->toArray();
        }

        $studentClasses = StudentClass::pluck('class_name', 'id');
        $sections = Section::pluck('section_name', 'id');
        $groups = Group::pluck('group_name', 'id');
        $shifts = Shift::pluck('shift_name', 'id');

        return view('pages.accounting.student_discount.create', compact(
            'tab',
            'student_name',
            'student_id_no',
            'studentClasses',
            'sections',
            'groups',
            'shifts',
            'students',
            'student_class_id',
            'section_id',
            'group_id',
            'shift_id',
            'previous_discount',
            'previous_discount_note'

        ));
    }

    public function store(Request $request)
    {
        $this->authorize('accounting.fees-discount.create');
        // Validate request data
        $request->validate([
            'student_id' => 'required',
            'discount_type' => 'required',
            'amount' => 'required',
            'note' => 'nullable|string',
        ]);
        $studentDetails = StudentInfo::where('id', $request->student_id)->first();
        // Create or update student discount
        $discount = StudentDiscount::updateOrCreate(
            ['student_id' => $request->student_id],
            [
                'branch_id' => $studentDetails->branch_id,
                'shift_id' => $studentDetails->shift_id,
                'section_id' => $studentDetails->section_id,
                'class_id' => $request->class_id,
                'discount_type' => $request->discount_type,
                'amount' => $request->amount,
                'note' => $request->note,
            ]
        );
        // Return a success response
        return response()->json(['success' => true, 'data' => $discount]);
    }
}
