<?php

namespace App\Http\Controllers\Admission;

use Illuminate\Http\Request;
use App\Services\FileUploadService;
use App\Http\Controllers\Controller;
use App\Models\Admission\OnlineAdmissionSetting;

class OnlineAdmissionSettingController extends Controller
{

    protected $fileUploadService;

    public function __construct(FileUploadService $fileUploadService)
    {
        $this->fileUploadService = $fileUploadService;
    }
    /**
     * Display a listing of the resource.
     */
    public function index()
    {
        $settings = OnlineAdmissionSetting::orderBy('id', 'desc')->first();
        return view('pages.admission.setting.index', compact('settings'));
    }

    public function update(Request $request, $id)
    {
        $setting = OnlineAdmissionSetting::findOrFail($id);
        $setting->session = $request->input('session');
        $setting->institute_name = $request->input('institute_name');
        $setting->status = $request->input('status') == '1' ? true : false;

        $logo = $request->institute_logo;
        if(!empty($logo)){
            $filePath = $this->fileUploadService->upload($logo, 'uploads/settings', $setting->institute_logo ?? '');
            $setting->institute_logo = $filePath;
        }
        $setting->save();
        return redirect()->route('admission-setting.index')->with('success', 'Online Admission Setting updated successfully.');
    }
}
