<?php

namespace App\Http\Controllers;

use App\Models\Result\Exam;
use Illuminate\Http\Request;
use App\Models\Academic\Shift;
use App\Http\Controllers\Controller;
use App\Services\StudentInfoService;

class AdmitCardController extends Controller
{

    protected $studentInfoService;

    public function __construct(StudentInfoService $studentInfoService)
    {
        $this->studentInfoService = $studentInfoService;
    }
    
    public function index(Request $request){
        $this->authorize('exam-result.admit-card.view');
        
        $data = $this->studentInfoService->getRelatedData();
        $data['exam_id'] = '';
        $data['exams'] = Exam::with('academic_year')->orderBy('id','desc')->get();
        $data['shifts'] = Shift::select('id', 'shift_name')->get();
       
        if (!empty($request->query())) {
            $data['students'] = $this->studentInfoService->getStudents($request->query());
        } else {
            $data['students'] = collect();
        }

        return view('pages.admit-card.index')->with($data);

    }

    public function filter(Request $request){
        $this->authorize('exam-result.admit-card.view');
        $data = $this->studentInfoService->getRelatedData();
        $data['exam_id'] = $request->exam ?? 0;
        $data['exams'] = Exam::with('academic_year')->orderBy('id','desc')->get();

        $data['shifts'] = Shift::select('id', 'shift_name')->get();
       
        $data['selected_exam'] =  Exam::where('id',$request->exam)->first();

        if (!empty($request->all())) {
            $data['students'] = $this->studentInfoService->getStudents($request->all());
        } else {
            $data['students'] = collect();
        }
        
        return view('pages.admit-card.index')->with($data);

    }

    public function filterAjax(Request $request){
        // Retrieve data sent from AJAX
        $data = $this->studentInfoService->getRelatedData();
        $data['exam_id'] = $request->input('exam') ?? 0;
        $data['exams'] = Exam::with('academic_year')->get();

        $data['selected_exam'] =  Exam::where('id',$request->exam)->first();

        if (!empty($request->query())) {
            $data['students'] = $this->studentInfoService->getStudents($request->query());
        } else {
            $data['students'] = collect();
        }
        // Return JSON response
        return response()->json([
            'status' => 'success',
            'data' => $data
        ]);
        
    }


}
