<?php

namespace App\Http\Controllers;

use App\Models\ApiToken;
use Illuminate\Http\Request;
use Illuminate\Support\Str;
use Illuminate\Support\Facades\Hash;
use Illuminate\Support\Facades\Crypt;

class ApiTokenController extends Controller
{
    /**
     * Display a listing of the resource.
     */
    public function index()
    {
        $apiToken = ApiToken::all();
        return view('pages.api_key.index',compact('apiToken'));
    }

    /**
     * Store a newly created resource in storage.
     */
    public function store(Request $request)
    {
        $request->validate([
            'name' => 'required|max:50',
            'api_name' => 'required|max:50',
        ]);

        $plainToken = Str::random(60);
        $api = new ApiToken();
        $api->name = $request->name;
        $api->api_name = $request->api_name;
        $api->api_token = Crypt::encryptString($plainToken);
        $api->save();
        return redirect()->route('apikey.index')->with('success', 'Api Token created successfully.');
    }
    /**
     * Update the specified resource in storage.
     */
    public function update(Request $request, ApiToken $apiToken)
    {
        $request->validate([
            'name' => 'required|max:50',
            'api_name' => 'required|max:50',
        ]);
        $api = ApiToken::findOrFail($request->id);
        $api->name = $request->name;
        $api->api_name = $request->api_name;
        $plainToken = Str::random(60);
        $api->api_token = Crypt::encryptString($plainToken);
        $api->save();
        return redirect()->route('apikey.index')->with('success', 'Api Token updated successfully.');
    }

    /**
     * Remove the specified resource from storage.
     */
    public function destroy( $id)
    {
        $api = ApiToken::findOrFail($id);
        $api->delete();
        return redirect()->route('apikey.index')->with('success', 'Api Token deleted successfully.');
    }
}
