<?php

namespace App\Http\Controllers\Guardian;

use App\Http\Controllers\Controller;
use App\Models\Guardian\GuardianRelation;
use Illuminate\Http\Request;

class GuardianRelationController extends Controller
{
    public function index()
    {
        $guardian_relations = GuardianRelation::all();
        return view('pages.hr-payroll.guardian_relation.index', compact('guardian_relations'));
    }

    public function create()
    {
        return view('pages.hr-payroll.guardian_relation.create');
    }


    public function store(Request $request)
    {
        $request->validate([
            // Define validation rules for guardian_relation creation
        ]);

        GuardianRelation::create($request->all());

        return redirect()->route('guardian_relation.index')
            ->with('success', 'GuardianRelation created successfully.');
    }

    public function show(GuardianRelation $guardian_relation)
    {
        return view('pages.hr-payroll.guardian_relation.show', compact('guardian_relation'));
    }


    public function edit(GuardianRelation $guardian_relation)
    {
        return view('pages.hr-payroll.guardian_relation.edit', compact('guardian_relation'));
    }


    public function update(Request $request)
    {
        $request->validate([
            'name' => 'required|string|max:250',
        ]);

        $guardian_relation = GuardianRelation::findOrFail($request->id);
        $guardian_relation->name = $request->name;
        $guardian_relation->save();

        return redirect()->route('guardian_relation.index')
            ->with('success', 'GuardianRelation updated successfully.');
    }


    public function destroy($id)
    {
        $guardian_relation = GuardianRelation::findOrFail($id);
        $guardian_relation->delete();

        return redirect()->route('guardian_relation.index')
            ->with('success', 'GuardianRelation deleted successfully.');
    }
}
