<?php

namespace App\Http\Controllers\Holiday;

use App\Http\Controllers\Controller;
use App\Models\Holiday\Holiday;
use Illuminate\Http\Request;
use DateTime;

class HolidayController extends Controller
{
    
    public function index(){
        $holidays = Holiday::orderBy('start_date','asc')->get();
        return view('pages.holiday.index',compact('holidays'));
    }


    public function copyRecord($id){
        $original = Holiday::findOrFail($id);
        $copy = $original->replicate();
        $holidays = Holiday::where('year', $original->year)->orderBy('start_date','asc')->get();
        $year = $original->year+1;
        return view('pages.holiday.copy',compact('holidays','year','original'));
    }

    public function copyStore(Request $request, $id){
        $request->validate([
            "year"    => "required|unique:holidays,year",
            "title"    => "required|array",
            "title.*"  => "required|string",
            "holiday_type"    => "required|array",
            "holiday_type.*"  => "required|string",
            'start_date' => 'required|array',
            'start_date.*' => 'required',
        ]);
        foreach ($request->title as $key => $title) {
            $year = strtotime($request->year);
            $newyear = date('Y',$year);
            
            $new_start_date = $request->start_date[$key].'-'.$request->year;
            $start_date = DateTime::createFromFormat("d-m-Y", $new_start_date)->format("Y-m-d");

            $new_end_date = $request->end_date[$key].'-'.$request->year;
            $end_date = DateTime::createFromFormat("d-m-Y", $new_end_date)->format("Y-m-d");

            $holiday = new Holiday();
            $holiday->title = $request->title[$key];
            $holiday->holiday_type = $request->holiday_type[$key];
            $holiday->start_date = $start_date;
            $holiday->end_date = $end_date;
            $holiday->year = $newyear;
            $holiday->branch_id = auth()->user()->branch_id;
            $holiday->user_id = auth()->user()->id;
            $holiday->save();
        }
        return redirect()->route('holiday.index')->with('success', 'Holiday created successfully.');
    }


    public function create(){
        return view('pages.holiday.create');
    }

    public function store(Request $request){
        $request->validate([
            "year"    => "required",
            "title"    => "required|array",
            "title.*"  => "required|string",
            "holiday_type"    => "required|array",
            "holiday_type.*"  => "required|string",
            'start_date' => 'required|array',
            'start_date.*' => 'required',
        ]);

        foreach ($request->title as $key => $title) {
            $year = strtotime($request->year);
            $newyear = date('Y',$year);

            $new_start_date = $request->start_date[$key].'-'.$request->year;
            $start_date = DateTime::createFromFormat("d-m-Y", $new_start_date)->format("Y-m-d");

            $new_end_date = $request->end_date[$key].'-'.$request->year;
            $end_date = DateTime::createFromFormat("d-m-Y", $new_end_date)->format("Y-m-d");

            $holiday = new Holiday();
            $holiday->title = $request->title[$key];
            $holiday->holiday_type = $request->holiday_type[$key];
            $holiday->start_date = $start_date;
            $holiday->end_date = $end_date;
            $holiday->year = $newyear;
            $holiday->branch_id = auth()->user()->branch_id;
            $holiday->user_id = auth()->user()->id;
            $holiday->save();
        }
        return redirect()->back()->with('success', 'Holiday created successfully.');
    }

    public function edit($id){
        $original = Holiday::find($id);
        $holidays = Holiday::where('year',$original->year)->get();
        return view('pages.holiday.edit',compact('original','holidays'));
    }

    public function update(Request $request, $id){

        foreach ($request->title as $key => $title) {
            $year = strtotime($request->year);
            $newyear = date('Y',$year);
            // $start_date = $request->start_date[$key];
            // $end_date = $request->end_date[$key];
            // $new_start_date = strtotime($start_date.'-'.$request->year);
            // $new_start_date = $request->year.'-'.$request->start_date[$key];
            // $new_end_date = strtotime($end_date);
            // $new_end_date = $new_end_date ? date('Y-m-d',$new_end_date) : $new_start_date;
            // $new_start_date = $request->year.'-'.$request->start_date[$key];
            // $new_end_date = $request->year.'-'.$request->end_date[$key];

            $new_start_date = $request->start_date[$key].'-'.$request->year;
            $start_date = DateTime::createFromFormat("d-m-Y", $new_start_date)->format("Y-m-d");

            $new_end_date = $request->end_date[$key].'-'.$request->year;
            $end_date = DateTime::createFromFormat("d-m-Y", $new_end_date)->format("Y-m-d");

            $holiday = Holiday::find($request->id[$key]);
            $holiday->title = $request->title[$key];
            $holiday->holiday_type = $request->holiday_type[$key];
            $holiday->start_date = $start_date;
            $holiday->end_date = $end_date;
            $holiday->year = $newyear;
            $holiday->branch_id = auth()->user()->branch_id;
            $holiday->user_id = auth()->user()->id;
            $holiday->save();
        }
        return redirect()->route('holiday.index')->with('success', 'Holiday updated successfully.');
    }
    public function destroy($id){
        $holiday = Holiday::find($id);
        $holidays = Holiday::where('year', $holiday->year)->get();
        foreach ($holidays as $key => $item) {
            $item->delete();
        }
        return redirect()->route('holiday.index')->with('success', 'Holiday deleted successfully.');
    }

    public function calendar(Request $request){
        $data['holidays'] = Holiday::all(['id', 'title', 'start_date', 'end_date']);
        return view('pages.holiday.calendar', $data);
    }
  
}
