<?php

namespace App\Http\Controllers\Homework;

use App\Http\Controllers\Controller;
use Illuminate\Http\Request;
use App\Models\Academic\Shift;
use App\Models\Academic\Group;
use App\Models\Academic\Section;
use App\Models\Academic\Subject;
use App\Models\Homework\Homework;
use Illuminate\Support\Facades\File;
use App\Models\Academic\StudentClass;
use App\Services\FileUploadService;
use App\Services\TeacherInfoService;
use Illuminate\Support\Facades\Auth;

class HomeworkController extends Controller
{
    protected $fileUploadService;
    protected $teacherInfoService;
    public function __construct(FileUploadService $fileUploadService, TeacherInfoService $teacherInfoService){
        $this->fileUploadService = $fileUploadService;
        $this->teacherInfoService = $teacherInfoService;
    }

    public function index(){
        $upcoming = Homework::where('submission_date','>=',now()->toDateString())->where('user_id','=',Auth::id())->get();
        $pasts = Homework::where('submission_date', '<=', now()->toDateString())->where('user_id', '=',Auth::id())->get();
        // dd($upcoming,$pasts );
        return view('pages.homework.homework.index',compact('upcoming','pasts'));
    }

    public function create(){
        $teacherInfo = $this->teacherInfoService->getEmployeeDataByUserID(Auth::id());
        $shift_id = '';
        $student_class_id = '';
        $subject_id = '';
        $section_id = '';
        $group_id = '';

        if(!empty($teacherInfo)){
            $shift_id = $teacherInfo->shift_id;
        }

        $shifts = Shift::pluck('shift_name','id');
        $studentClasses = StudentClass::pluck('class_name','id');
        $subjects = Subject::pluck('subject_name','id');
        $sections = Section::pluck('section_name','id');
        $groups = Group::pluck('group_name','id');
        return view('pages.homework.homework.create',compact('shifts','studentClasses','subjects','sections','groups','shift_id','student_class_id','subject_id','section_id','group_id'));
    }

    public function store(Request $request){
        $teacherInfo = $this->teacherInfoService->getEmployeeDataByUserID(Auth::id());
        $shift_id = null;
        if(!empty($teacherInfo)){
            $shift_id = $teacherInfo->shift_id;
        }else{
            $shift_id = 1;
        }
        $request->validate([
            'student_class_id' => 'required|integer',
            'subject_id' => 'required|integer',
            'section_id' => 'nullable|integer',
            'homework_date' => 'required|date',
            'submission_date' => 'required|date',
            'title' => 'required|string|max:250',
            'marks' => 'nullable|integer|max:100',
            'description' => 'nullable|string',
            'attachment' => 'max:200',
        ]);
        $homework = new Homework();
        $homework->branch_id = auth()->user()->branch_id;
        $homework->shift_id = $shift_id;
        $homework->student_class_id = $request->student_class_id;
        $homework->subject_id = $request->subject_id;
        $homework->section_id = $request->section_id;
        $homework->homework_date = store_date_format($request->homework_date);
        $homework->submission_date = store_date_format($request->submission_date);
        $homework->title = $request->title;
        $homework->marks = $request->marks;
        $homework->description = $request->description;
        $homework->user_id = auth()->id();
        $homework->teacher_id = auth()->id();
        $homework->created_by = auth()->id();
        if($request->hasFile('attachment')){
            $file = $request->file('attachment');
            $file_name = $this->fileUploadService->upload($file,'uploads/homework');
            $homework->attachment = $file_name;
        }
        $homework->save();
        return redirect()->route('homework.index')->with('success', 'Homework created successfully!');
    }

    public function show($id){
        $homework = Homework::find($id);
        return view('pages.homework.homework.show',compact('homework'));
    }

    public function edit($id){
        $homework = Homework::find($id);
        $shift_id = '';
        $student_class_id = '';
        $subject_id = '';
        $section_id = '';
        $group_id = '';
        $shifts = Shift::pluck('shift_name','id');
        $studentClasses = StudentClass::pluck('class_name','id');
        $subjects = Subject::pluck('subject_name','id');
        $sections = Section::pluck('section_name','id');
        $groups = Group::pluck('group_name','id');
        return view('pages.homework.homework.edit',compact('shifts','studentClasses','subjects','sections','groups','shift_id','student_class_id','subject_id','section_id','group_id','homework'));
    }

    public function update(Request $request, $id){
        $teacherInfo = $this->teacherInfoService->getEmployeeDataByUserID(Auth::id());
        $shift_id = null;
        if(!empty($teacherInfo)){
            $shift_id = $teacherInfo->shift_id;
        }
        $request->validate([
            'student_class_id' => 'required|integer',
            'subject_id' => 'required|integer',
            'section_id' => 'nullable|integer',
            'homework_date' => 'required|date',
            'submission_date' => 'required|date',
            'title' => 'required|string|max:250',
            'marks' => 'nullable|integer|max:100',
            'description' => 'nullable|string',
            'attachment' => 'max:200',
        ]);
        $homework = Homework::find($id);
        $homework->branch_id = auth()->user()->branch_id;
        $homework->shift_id = $shift_id;
        $homework->student_class_id = $request->student_class_id;
        $homework->subject_id = $request->subject_id;
        $homework->section_id = $request->section_id;
        $homework->homework_date = store_date_format($request->homework_date);
        $homework->submission_date = store_date_format($request->submission_date);
        $homework->title = $request->title;
        $homework->marks = $request->marks;
        $homework->description = $request->description;
        $homework->user_id = auth()->id();
        $homework->teacher_id = auth()->id();
        $homework->created_by = auth()->id();
        if($request->hasFile('attachment')){
            $file = $request->file('attachment');
            $file_name = $this->fileUploadService->upload($file,'uploads/homework',$homework->attachment);
            $homework->attachment = $file_name;
        }
        $homework->save();
        return redirect()->route('homework.index')->with('success', 'Homework updated successfully!');
    }

    public function destroy($id){
        $homework = Homework::find($id);
        $previousImagePath = public_path($homework->attachment);
        if (File::exists($previousImagePath)) {
            $file = File::delete($previousImagePath);
        }
        $homework->delete();
        return redirect()->route('homework.index')->with('success', 'Homework updated successfully!');
    }

    
}
