<?php

namespace App\Http\Controllers\Homework;

use App\Http\Controllers\Controller;

use Illuminate\Support\Str;
use Illuminate\Http\Request;
use App\Models\Homework\Homework;
use App\Models\Academic\StudentClass;
use Illuminate\Support\Facades\Auth;
use App\Models\Homework\HomeworkSubmission;

class HomeworkSubmissionController extends Controller
{
    public function index(){
        $homeworks = Homework::all();
        return view('pages.homework.submission.index',compact('homeworks'));
    }

    public function create(){
        $student_class_id = '';
        $studentClasses = StudentClass::pluck('class_name','id');
        $homeworks = Homework::all();
        return view('pages.homework.submission.create',compact('homeworks','student_class_id','studentClasses'));
    }

    public function store(Request $request){ 
        if($request->hasfile('attachment')){
            $files = $request->file('attachment');
            foreach ($files as $key => $file) {
                $date_time = date('YmdHis');
                $fileName = $file->getClientOriginalName();
                $fileExt = $file->getClientOriginalExtension();
                $fileOrgName = basename($fileName,".".$fileExt);
                $fileName = Str::slug($fileOrgName).'-'.$date_time.'.'.$fileExt;
                $file->move(public_path('/uploads/homework-student/'), $fileName);
            }
        }
        return redirect()->back()->with('success', 'Attachment uploaded successfully!');
    }

    public function resultView(){
        // dd('resultView');
        $searchBy = '';
        $results = '';
        $homeworks = Homework::orderBy('id', 'desc')->where('user_id', '=',Auth::id())->get();
        return view('pages.homework.submission.result-view',compact('homeworks','searchBy','results'));
    }

    public function resultViewSearch(Request $request){
        $searchBy = Homework::find($request->homework_id);
        $results = HomeworkSubmission::where('homework_id','=',$request->homework_id)->get();
        $homeworks = Homework::where('submission_date', '<=', now()->toDateString())->where('user_id', '=',Auth::id())->get();
        return view('pages.homework.submission.result-view',compact('homeworks','searchBy','results'));
    }
    public function resultMarksEntry(Request $request){
        $request->validate([
            'student_id' => 'required|array',
            'marks' => 'required|array',
            'homework_id' => 'required|integer',
        ]);
        if (count($request['student_id']) !== count($request['marks'])) {
            return back()->withErrors(['error' => 'Mismatch between students and marks']);
        }
        foreach ($request['student_id'] as $key => $student_id) {
            $marks = $request['marks'][$key]; // Get the mark for the current student
            $homework_id = $request['homework_id'];
            HomeworkSubmission::where('homework_id', $homework_id)
                ->where('student_id', $student_id)
                ->update(['marks' => $marks,'status' => 1]);
        }
        return redirect()->route('homework.result.view')->with('success', 'Marks updated successfully!');
    }
}
