<?php

namespace App\Http\Controllers\Hostel;

use App\Constants\Common;
use App\Http\Controllers\Controller;
use App\Models\Academic\Branch;
use App\Models\Hostel\Hostel;
use App\Models\Hostel\HostelFloor;
use Illuminate\Http\Request;
use Illuminate\Support\Facades\DB;
use Illuminate\Support\Facades\Log;

class HostelController extends Controller
{

    public function index()
    {
        $hostels = Hostel::get();
        $hostelType = Common::HOSTEL_TYPE;
        return view('pages.hostels.hostel.index', compact('hostels', 'hostelType'));
    }

    public function create()
    {
        return view('pages.hostels.hostel.create');
    }

    public function store(Request $request)
    {
        $request->validate([
            'name' => 'required|string|max:255',
            'no_of_floor' => 'nullable|numeric',
            'address' => 'nullable|string|max:255',
        ]);

        try {
            DB::transaction(function () use ($request) {

                $no_of_floor = $request->no_of_floor;

                $hostel = Hostel::create([
                    'branch_id' => auth()->user()->branch_id,
                    'name' => $request->name,
                    'no_of_floor' => $no_of_floor,
                    'address' => $request->address,
                ]);

                // $hostel_rooms = [];
                // for ($i = 1; $i <= $no_of_floor; $i++) {
                //     $floorName = Common::ORDINAL_SUFFIXES[$i] ?? $i.' th';
                //     $hostel_rooms[] = [
                //         'hostel_id' => $hostel->id,
                //         'name' => $floorName,
                //         'created_at' => now(),
                //     ];
                // }
                // HostelFloor::insert($hostel_rooms);

            });

            return redirect()->route('hostel.index')
                ->with('success', 'Hostel created successfully.');

        } catch (\Exception $e) {
            Log::error('Error update hostel: ' . $e->getMessage());
            return redirect()->back()->with('error', 'Failed to create hostel.');
        }
    }

    public function show(Hostel $hostel)
    {
        return view('hostels.show', compact('hostel'));
    }

    public function edit(Hostel $hostel)
    {
        $branches = Branch::all();
        return view('hostels.edit', compact('hostel', 'branches'));
    }

    public function update(Request $request, Hostel $hostel)
    {
        $request->validate([
            'name' => 'required|string|max:255',
            'no_of_floor' => 'nullable|numeric',
            'address' => 'nullable|string|max:255',
        ]);

        try {

            DB::transaction(function () use ($request, $hostel) {
                $no_of_floor = $request->no_of_floor;
                $pre_no_of_floor =  $hostel->no_of_floor;


                $hostel->update([
                    'branch_id' => auth()->user()->branch_id,
                    'name' => $request->name,
                    'no_of_floor' => $request->no_of_floor,
                    'address' => $request->address,
                ]);

                // if($no_of_floor!=$pre_no_of_floor){
                //     if ($no_of_floor > $pre_no_of_floor) {
                //         $hostel_rooms = [];
                //         for ($i = 1; $i <= $no_of_floor; $i++) {
                //             $floorName = Common::ORDINAL_SUFFIXES[$i] ?? $i.' th';
                //             $hostel_rooms[] = [
                //                 'hostel_id' => $hostel->id,
                //                 'name' => $floorName,
                //                 'updated_at' => now(),
                //             ];
                //         }

                //         HostelFloor::insert($hostel_rooms);
                //     } else {
                //         HostelFloor::where('hostel_id', $hostel->id)
                //             ->where('name', '>=', Common::ORDINAL_SUFFIXES[$no_of_floor + 1])
                //             ->delete();
                //     }
                // }

            });

            return redirect()->route('hostel.index')
                    ->with('success', 'Hostel updated successfully.');

        } catch (\Exception $e) {
            Log::error('Error creating hostel: ' . $e->getMessage());
            return redirect()->back()->with('error', 'Failed to create hostel.');
        }
    }

    public function destroy(Hostel $hostel)
    {
        $hostel->delete();

        return redirect()->route('hostel.index')
            ->with('success', 'Hostel deleted successfully');
    }
}
