<?php

namespace App\Http\Controllers\Hostel;

use App\Constants\Status;
use App\Http\Controllers\Controller;
use App\Models\Hostel\Hostel;
use App\Models\Hostel\HostelFloor;
use App\Models\Hostel\HostelRoom;
use App\Models\Hostel\RoomType;
use Illuminate\Http\Request;
use Illuminate\Support\Facades\DB;

class HostelRoomController extends Controller
{
    public function index()
    {
        $hostelRooms = HostelRoom::with(['hostel', 'hostelFloor', 'roomType'])
        ->whereHas('hostel')
        ->get();
        $hostels = Hostel::all();
        $roomTypes = RoomType::all();
        return view('pages.hostels.hostel_room.index', compact('hostelRooms', 'hostels', 'roomTypes'));
    }

    public function create()
    {
        // Not needed, using modal for create
    }

    public function store(Request $request)
    {
        $request->validate([
            'room_name' => 'required|string',
            'hostel_id' => 'required',
            'room_type_id' => 'required',
            'hostel_floor_id' => 'required',
            'no_of_bed' => 'required',
        ]);

        HostelRoom::create([
            'room_name' => $request->room_name,
            'hostel_id' => $request->hostel_id,
            'room_type_id' => $request->room_type_id,
            'hostel_floor_id' => $request->hostel_floor_id,
            'no_of_bed' => $request->no_of_bed,
        ]);

        return redirect()->route('hostel-room.index')->with('success', 'Hostel room created successfully!');
    }

    public function edit(HostelRoom $hostelRoom)
    {
        // Not needed, using modal for edit
    }

    public function update(Request $request, HostelRoom $hostelRoom)
    {
        $request->validate([
            'room_name' => 'required|string',
            'hostel_id' => 'required',
            'room_type_id' => 'required',
            'hostel_floor_id' => 'required',
            'no_of_bed' => 'required',
        ]);

        $hostelRoom->update([
            'room_name' => $request->room_name,
            'hostel_id' => $request->hostel_id,
            'room_type_id' => $request->room_type_id,
            'hostel_floor_id' => $request->hostel_floor_id,
            'no_of_bed' => $request->no_of_bed,
        ]);

        return redirect()->route('hostel-room.index')->with('success', 'Hostel Room updated successfully!');
    }

    public function destroy(HostelRoom $hostelRoom)
    {
        $hostelRoom->delete();
        return redirect()->route('hostel-room.index')->with('success', 'Hostel Room deleted successfully!');
    }

    public function getHostelFloors(Request $request)
    {
        $hostel_floors = HostelFloor::where('hostel_id', $request->hostel_id)->get();
        return response()->json($hostel_floors);
    }

    public function getHostelRooms(Request $request)
    {
        $hostel_floor_id = $request->hostel_floor_id;
        // $hostel_rooms = HostelRoom::with('roomType')->where('hostel_floor_id', $request->hostel_floor_id)->get();
        $hostel_rooms = HostelRoom::with(['roomType'])
            ->leftJoin('student_hostels', function ($join) {
                $join->on('hostel_rooms.id', '=', 'student_hostels.hostel_room_id')
                    ->where('student_hostels.status', '=', Status::ASSIGNED);
            })
            ->select('hostel_rooms.*', DB::raw('COUNT(student_hostels.id) as assigned_beds'))
            ->where('hostel_rooms.hostel_floor_id', $hostel_floor_id)
            ->groupBy('hostel_rooms.id')
            ->get()
            ->map(function ($room) {
                $room->assigned_beds = $room->assigned_beds ?? 0;
                $room->empty_beds = $room->no_of_bed - $room->assigned_beds;
                return $room;
            });
        return response()->json($hostel_rooms);
    }

    

     public function roomList(Request $request){
        // $section_ids = ClassSection::where('student_class_id',$request->student_class_id)->pluck('section_id')->toArray();
        // $sections = Section::whereIn('id',$section_ids)->get();
        $rooms = HostelRoom::where('hostel_id',$request->hostel_id)->get();
        return response()->json($rooms,200);
    }
}
